/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.LongHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.ColumnDefinitionTriplet;

public class ColumnDefinitionTripletArray
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(ColumnDefinitionTripletArray.class);
    protected long columnNumber = 0L;
    protected List<ColumnDefinitionTriplet> columns = new ArrayList<ColumnDefinitionTriplet>();

    @Override
    public ByteHandler initialize() {
        this.addHandler(new LongHandler(){

            @Override
            public void setLong(long str) throws Exception {
                ColumnDefinitionTripletArray.this.columnNumber = str;
                if (0L < ColumnDefinitionTripletArray.this.columnNumber) {
                    for (long i = 0L; i < ColumnDefinitionTripletArray.this.columnNumber; ++i) {
                        ChildHandler ch = new ChildHandler();
                        ch.initialize();
                        ColumnDefinitionTripletArray.this.stack.add(0, ch);
                    }
                }
            }
        }.setByteLength(4).setLabel("Data Set Column Array"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("ColumnDefinitionTripletArray: Length=%s, %s", this.columnNumber, this.columns);
        return f.toString();
    }

    public List<ColumnDefinitionTriplet> getElements() {
        return Collections.unmodifiableList(this.columns);
    }

    public int size() {
        return this.columns.size();
    }

    public String toDump() {
        StringBuilder sb = new StringBuilder();
        sb.append("KEY\tVALUE\tTYPE\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnDefinitionTriplet pt = this.columns.get(i);
            sb.append(pt.getName()).append("\t");
            sb.append("\"").append(pt.getType()).append("\"\t");
            sb.append(pt.getSize()).append("\n");
        }
        return sb.toString();
    }

    public class ChildHandler
    extends ColumnDefinitionTriplet {
        @Override
        public void complete() {
            ColumnDefinitionTripletArray.this.columns.add(this);
        }
    }
}

