/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.IntHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.LongHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.UTF8StringHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataFileHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataHeader;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataSet;

public class GenericDataGroup
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenericDataGroup.class);
    private GenericDataHeader header;
    private GenericDataFileHandler handler;
    protected long nextDataGroupPosition;
    protected long firstDataSetPosition;
    protected String name;
    protected int setCount;
    protected List<GenericDataSet> dataSetList = new ArrayList<GenericDataSet>();

    public GenericDataGroup setHandler(GenericDataFileHandler hndlr) {
        this.handler = hndlr;
        return this;
    }

    public GenericDataGroup setDataHeader(GenericDataHeader hdr) {
        this.header = hdr;
        return this;
    }

    public GenericDataHeader getHeader() {
        return this.header;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ByteHandler initialize() {
        this.addHandler(new LongHandler(){

            @Override
            public void setLong(long l) {
                GenericDataGroup.this.nextDataGroupPosition = l;
            }
        }.setByteLength(4).setLabel("File pos of next data group"));
        this.addHandler(new LongHandler(){

            @Override
            public void setLong(long l) {
                GenericDataGroup.this.firstDataSetPosition = l;
            }
        }.setByteLength(4).setLabel("File pos of first data set"));
        this.addHandler(new IntHandler(){

            @Override
            public void setInt(int ct) throws Exception {
                GenericDataGroup.this.setCount = ct;
                GenericDataGroup.this.addDataSet();
            }
        }.setLabel("Data Sets"));
        this.addHandler(new UTF8StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                GenericDataGroup.this.name = str;
            }
        }.setLabel("Data Group Name"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("GenericDataGroup: Name=%s, NextGroupPos=%s, FirstDataSetPos=%s, Length=%s, Datasets=%s", this.name, this.nextDataGroupPosition, this.firstDataSetPosition, this.setCount, this.dataSetList);
        return f.toString();
    }

    public List<GenericDataSet> getDataSets() {
        return Collections.unmodifiableList(this.dataSetList);
    }

    protected void addDataSet() {
        if (this.setCount > this.dataSetList.size()) {
            InnerDataSet ids = new InnerDataSet();
            ids.setHandler(this.handler).setGroup(this);
            ids.initialize();
            this.stack.add(0, ids);
        }
    }

    public class InnerDataSet
    extends GenericDataSet {
        @Override
        public void complete() {
            GenericDataGroup.this.dataSetList.add(this);
            GenericDataGroup.this.addDataSet();
        }
    }
}

