/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.StringHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.UTF8StringHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataHeaderArray;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.ParameterTripletArray;

public class GenericDataHeader
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenericDataHeader.class);
    private String dataType;
    private String guid;
    private String datetime;
    private String locale;
    private ParameterTripletArray parameterArray;
    private GenericDataHeaderArray parentArray;

    @Override
    public ByteHandler initialize() {
        this.addHandler(new StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                GenericDataHeader.this.setDataType(str);
            }
        }.setLabel("Data Type"));
        this.addHandler(new StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                GenericDataHeader.this.setGuid(str);
            }
        }.setLabel("Guid"));
        this.addHandler(new UTF8StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                GenericDataHeader.this.setDatetime(str);
            }
        }.setLabel("Datetime"));
        this.addHandler(new UTF8StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                GenericDataHeader.this.setLocale(str);
            }
        }.setLabel("Locale"));
        this.addHandler(new ParameterTripletArray(){

            @Override
            public void complete() {
                GenericDataHeader.this.setParameterArray(this);
            }
        }.setLabel("Parameter Array"));
        this.addHandler(new GenericDataHeaderArray(){

            @Override
            public void complete() {
                GenericDataHeader.this.setParentArray(this);
            }
        }.setLabel("Parent Header Array"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("CommandConsoleHeader: DataType=%s, Guid=%s, Datetime=%s, Locale=%s, %s, %s", this.getDataType(), this.getGuid(), this.getDatetime(), this.getLocale(), this.getParameterArray(), this.getParentArray());
        return f.toString();
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public String getLocale() {
        return this.locale;
    }

    public ParameterTripletArray getParameterArray() {
        return this.parameterArray;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setParameterArray(ParameterTripletArray parameterArray) {
        this.parameterArray = parameterArray;
    }

    public GenericDataHeaderArray getParentArray() {
        return this.parentArray;
    }

    public void setParentArray(GenericDataHeaderArray parentArray) {
        this.parentArray = parentArray;
    }
}

