/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.IntHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataHeader;

public class GenericDataHeaderArray
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenericDataHeaderArray.class);
    protected int parentCount = 0;
    protected List<GenericDataHeader> parents = new ArrayList<GenericDataHeader>();

    @Override
    public ByteHandler initialize() {
        this.addHandler(new IntHandler(){

            @Override
            public void setInt(int str) throws Exception {
                GenericDataHeaderArray.this.parentCount = str;
                if (0 < GenericDataHeaderArray.this.parentCount) {
                    for (int i = 0; i < GenericDataHeaderArray.this.parentCount; ++i) {
                        ChildHandler ch = new ChildHandler();
                        ch.initialize();
                        GenericDataHeaderArray.this.stack.add(0, ch);
                    }
                }
            }
        }.setLabel("Parent Header Array"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("ParentGenericDataHeaders: Length=%s, ActualLength=%s", this.parentCount, this.parents.size());
        return f.toString();
    }

    public List<GenericDataHeader> getElements() {
        return Collections.unmodifiableList(this.parents);
    }

    public int size() {
        return this.parents.size();
    }

    public class ChildHandler
    extends GenericDataHeader {
        @Override
        public void complete() {
            GenericDataHeaderArray.this.parents.add(this);
        }
    }
}

