/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.FloatHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.IntHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.LongHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.ColumnDefinitionTriplet;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataRowStringHandler;

public abstract class GenericDataRowHandler
extends CompositeByteHandler {
    protected List<ByteHandler> handlerList = new ArrayList<ByteHandler>();
    protected long rowNumber;
    protected Object[] currentArray;
    protected int currentColumn;
    protected int currentRow;

    public GenericDataRowHandler(List<ColumnDefinitionTriplet> columns, long rowNumber) {
        this.rowNumber = rowNumber;
        this.addColumns(columns);
    }

    @Override
    public ByteHandler initialize() {
        this.stack.addAll(this.handlerList);
        this.currentColumn = 0;
        return super.initialize();
    }

    @Override
    public ByteHandler reset() {
        for (ByteHandler bh : this.handlerList) {
            bh.reset();
        }
        this.stack.clear();
        this.stack.addAll(this.handlerList);
        Collections.reverse(this.stack);
        this.currentArray = null;
        this.currentColumn = 0;
        return super.reset();
    }

    @Override
    public boolean next(byte b) throws Exception {
        boolean rv;
        if (null == this.currentArray) {
            this.currentArray = new Object[this.handlerList.size()];
        }
        if (rv = super.next(b)) {
            this.handleRow(this.currentArray);
            ++this.currentRow;
            this.reset();
            return this.rowNumber <= (long)this.currentRow;
        }
        return false;
    }

    public abstract void handleRow(Object[] var1);

    public final void addColumns(List<ColumnDefinitionTriplet> columns) {
        for (ColumnDefinitionTriplet cdf : columns) {
            this.addColumn(cdf);
        }
    }

    public final void addColumn(ColumnDefinitionTriplet column) {
        ByteHandler bah = null;
        switch (column.getType()) {
            case 0: {
                bah = new IntColHandler().setByteLength(1);
                break;
            }
            case 1: {
                bah = new IntColHandler().setByteLength(1);
                break;
            }
            case 2: {
                bah = new IntColHandler().setByteLength(2);
                break;
            }
            case 3: {
                bah = new IntColHandler().setByteLength(2);
                break;
            }
            case 4: {
                bah = new IntColHandler().setByteLength(4);
                break;
            }
            case 5: {
                bah = new LongColHandler().setByteLength(4);
                break;
            }
            case 6: {
                bah = new FloatColHandler().setByteLength(4);
                break;
            }
            case 7: {
                bah = new StringColHandler(column.getSize());
                break;
            }
            case 8: {
                bah = new UTF8StringColHandler(column.getSize());
            }
        }
        this.handlerList.add(bah);
    }

    public class UTF8StringColHandler
    extends GenericDataRowStringHandler.GenericDataRowUtf8StringHandler {
        public UTF8StringColHandler(int maxLength) {
            super(maxLength);
        }

        @Override
        public void setString(String str) throws Exception {
            GenericDataRowHandler.this.currentArray[GenericDataRowHandler.this.currentColumn] = str;
            ++GenericDataRowHandler.this.currentColumn;
        }
    }

    public class StringColHandler
    extends GenericDataRowStringHandler {
        public StringColHandler(int maxLength) {
            super(maxLength - 4);
        }

        @Override
        public boolean next(byte b) throws Exception {
            return super.next(b);
        }

        @Override
        public void setString(String str) throws Exception {
            GenericDataRowHandler.this.currentArray[GenericDataRowHandler.this.currentColumn] = str;
            ++GenericDataRowHandler.this.currentColumn;
        }
    }

    public class FloatColHandler
    extends FloatHandler {
        @Override
        public boolean next(byte b) throws Exception {
            return super.next(b);
        }

        @Override
        public void setFloat(float f) throws Exception {
            GenericDataRowHandler.this.currentArray[GenericDataRowHandler.this.currentColumn] = new Float(f);
            ++GenericDataRowHandler.this.currentColumn;
        }
    }

    public class LongColHandler
    extends LongHandler {
        @Override
        public void setLong(long l) throws Exception {
            GenericDataRowHandler.this.currentArray[GenericDataRowHandler.this.currentColumn] = new Long(l);
            ++GenericDataRowHandler.this.currentColumn;
        }
    }

    public class IntColHandler
    extends IntHandler {
        @Override
        public boolean next(byte b) throws Exception {
            return super.next(b);
        }

        @Override
        public void setInt(int i) throws Exception {
            GenericDataRowHandler.this.currentArray[GenericDataRowHandler.this.currentColumn] = new Integer(i);
            ++GenericDataRowHandler.this.currentColumn;
        }
    }
}

