/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.LongHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.UTF8StringHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.ColumnDefinitionTriplet;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.ColumnDefinitionTripletArray;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataFileHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataGroup;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataRowHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.ParameterTripletArray;

public class GenericDataSet
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenericDataSet.class);
    private GenericDataGroup group;
    private GenericDataFileHandler handler;
    private long firstDataElementPosition;
    private long nextDataSetPosition;
    private String name;
    private ParameterTripletArray parameterArray;
    private ColumnDefinitionTripletArray columnArray;
    private long rowNumber;
    private GenericDataRowHandler rowHandler;

    public GenericDataSet setHandler(GenericDataFileHandler hndlr) {
        if (null == hndlr) {
            throw new NullPointerException();
        }
        this.handler = hndlr;
        return this;
    }

    public GenericDataSet setGroup(GenericDataGroup grp) {
        if (null == grp) {
            throw new NullPointerException();
        }
        this.group = grp;
        return this;
    }

    @Override
    public ByteHandler initialize() {
        this.addHandler(new LongHandler(){

            @Override
            public void setLong(long l) {
                GenericDataSet.this.setFirstDataElementPosition(l);
            }
        }.setByteLength(4).setLabel("File pos of next data group"));
        this.addHandler(new LongHandler(){

            @Override
            public void setLong(long l) {
                GenericDataSet.this.setNextDataSetPosition(l);
            }
        }.setByteLength(4).setLabel("File pos of first data set"));
        this.addHandler(new UTF8StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                GenericDataSet.this.setName(str);
            }
        }.setLabel("Data Set Name"));
        this.addHandler(new ParameterTripletArray(){

            @Override
            public void complete() {
                GenericDataSet.this.setParameterArray(this);
            }
        }.setLabel("Data Set Parameter Array"));
        this.addHandler(new ColumnDefinitionTripletArray(){

            @Override
            public void complete() {
                GenericDataSet.this.setColumnArray(this);
            }
        }.setLabel("Data Set Column Array"));
        this.addHandler(new LongHandler(){

            @Override
            public void setLong(long l) {
                GenericDataSet.this.setRowNumber(l);
                if (0L < GenericDataSet.this.rowNumber) {
                    InnerGenericDataRowHandler hdlr = new InnerGenericDataRowHandler(GenericDataSet.this.columnArray.getElements(), GenericDataSet.this.rowNumber);
                    hdlr.initialize();
                    GenericDataSet.this.setRowHandler(hdlr);
                    GenericDataSet.this.stack.add(0, hdlr);
                }
            }
        }.setByteLength(4).setLabel("Row Number"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("GenericDataSet: Name=%s, FirstDataElementPos=%s, NextDataSetPos=%s, ParameterArray=[%s], ColumnArray=[%s], ExpectedRowNumber=%s", this.name, this.firstDataElementPosition, this.nextDataSetPosition, this.parameterArray, this.columnArray, this.rowNumber);
        return f.toString();
    }

    public GenericDataGroup getGroup() {
        return this.group;
    }

    public long getFirstDataElementPosition() {
        return this.firstDataElementPosition;
    }

    public void setFirstDataElementPosition(long firstDataElementPosition) {
        this.firstDataElementPosition = firstDataElementPosition;
    }

    public long getNextDataSetPosition() {
        return this.nextDataSetPosition;
    }

    public void setNextDataSetPosition(long nextDataSetPosition) {
        this.nextDataSetPosition = nextDataSetPosition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ParameterTripletArray getParameterArray() {
        return this.parameterArray;
    }

    public void setParameterArray(ParameterTripletArray parameterArray) {
        this.parameterArray = parameterArray;
    }

    public ColumnDefinitionTripletArray getColumnArray() {
        return this.columnArray;
    }

    public void setColumnArray(ColumnDefinitionTripletArray columnArray) {
        this.columnArray = columnArray;
    }

    public long getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(long rowNumber) {
        this.rowNumber = rowNumber;
    }

    public GenericDataRowHandler getRowHandler() {
        return this.rowHandler;
    }

    public void setRowHandler(GenericDataRowHandler rowLoader) {
        this.rowHandler = rowLoader;
    }

    public class InnerGenericDataRowHandler
    extends GenericDataRowHandler {
        public InnerGenericDataRowHandler(List<ColumnDefinitionTriplet> columns, long rowNumber) {
            super(columns, rowNumber);
        }

        @Override
        public void handleRow(Object[] row) {
            try {
                GenericDataSet.this.handler.handleData(GenericDataSet.this, row);
            }
            catch (NullPointerException npe) {
                System.out.println("Handler is " + GenericDataSet.this.handler);
                System.out.println("Row is " + row);
                System.out.println("DataSet is " + GenericDataSet.this);
                throw npe;
            }
        }
    }
}

