/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.IntHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.LongHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.CommandConsoleFormatException;

public class GenericFileHeader
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenericFileHeader.class);
    public static final int MAGIC_NUMBER = 59;
    public static final int VERSION_NUMBER = 1;
    protected Integer dataGroupNumber;
    protected Long firstDataGroupPosition;

    @Override
    public ByteHandler initialize() {
        this.addHandler(new IntHandler(){

            @Override
            public void setInt(int i) throws Exception {
                if (59 != i) {
                    throw new CommandConsoleFormatException("Expecting the Magic Number (1st pos) to be 59. Found: " + i);
                }
            }
        }.setByteLength(1).setLabel("Magic Number"));
        this.addHandler(new IntHandler(){

            @Override
            public void setInt(int i) throws Exception {
                if (1 != i) {
                    LOGGER.warn("Expecting the version number (2nd pos) to be 1 . Found: " + i);
                }
            }
        }.setByteLength(1).setLabel("Version Number"));
        this.addHandler(new IntHandler(){

            @Override
            public void setInt(int i) {
                GenericFileHeader.this.dataGroupNumber = i;
            }
        }.setByteLength(4).setLabel("No. Of Data Groups"));
        this.addHandler(new LongHandler(){

            @Override
            public void setLong(long l) {
                GenericFileHeader.this.firstDataGroupPosition = l;
            }
        }.setByteLength(4).setLabel("File pos of first data group"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("CommandConsoleHeader: DataGroupNo=%s, FirstDataGroupPosition=%s", this.dataGroupNumber, this.firstDataGroupPosition);
        return f.toString();
    }
}

