/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.BinaryUtilities;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.UTF8StringHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.VarByteArrayHandler;

public abstract class ParameterTriplet
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(ParameterTriplet.class);
    public static final Charset UTF_16_CHARSET = Charset.forName("UTF-16");
    private String name;
    private byte[] value;
    private String type;

    @Override
    public ByteHandler initialize() {
        this.addHandler(new UTF8StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                ParameterTriplet.this.setName(str);
            }
        }.setLabel("ParameterTriplet: Name"));
        this.addHandler(new VarByteArrayHandler(){

            @Override
            public void setBytes(byte[] ba) throws Exception {
                ParameterTriplet.this.setValue(ba);
            }
        }.setLabel("ParameterTriplet: Value"));
        this.addHandler(new UTF8StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                ParameterTriplet.this.setType(str);
            }
        }.setLabel("ParameterTriplet: Type"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("ParameterTriplet: Name=%s, Value=%s, Type=%s", this.getName(), this.getObject(), this.getType());
        return f.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getObject() {
        switch (this.type) {
            case "text/plain": {
                return new String(this.value, UTF_16_CHARSET);
            }
            case "text/x-calvin-integer-32": {
                return this.toInteger();
            }
            case "text/x-calvin-float": {
                return this.toFloat();
            }
            case "text/x-calvin-unsigned-integer-8": {
                return this.toInteger8();
            }
        }
        return new String(this.value);
    }

    public Object toInteger() {
        byte[] ba = Arrays.copyOf(this.value, 4);
        return BinaryUtilities.bytesToLongBe(ba);
    }

    public Object toInteger8() {
        byte[] ba = Arrays.copyOf(this.value, 1);
        return BinaryUtilities.bytesToLongBe(ba);
    }

    public Object toFloat() {
        byte[] ba = Arrays.copyOf(this.value, 4);
        float f = BinaryUtilities.bytesToFloatBe(ba);
        return Float.valueOf(f);
    }
}

