/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.IntHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.ParameterTriplet;

public class ParameterTripletArray
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(ParameterTripletArray.class);
    protected int parameterNumber = 0;
    protected List<ParameterTriplet> parameters = new ArrayList<ParameterTriplet>();

    @Override
    public ByteHandler initialize() {
        this.addHandler(new IntHandler(){

            @Override
            public void setInt(int str) throws Exception {
                ParameterTripletArray.this.parameterNumber = str;
                if (0 < ParameterTripletArray.this.parameterNumber) {
                    for (int i = 0; i < ParameterTripletArray.this.parameterNumber; ++i) {
                        ChildHandler ch = new ChildHandler();
                        ch.initialize();
                        ParameterTripletArray.this.stack.add(0, ch);
                    }
                }
            }
        }.setLabel("Parameter Array"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("ParameterTripletArray: Length=%s, ActualLength=%s", this.parameterNumber, this.parameters.size());
        return f.toString();
    }

    public List<ParameterTriplet> getElements() {
        return Collections.unmodifiableList(this.parameters);
    }

    public int size() {
        return this.parameters.size();
    }

    public String toParameterDump() {
        StringBuilder sb = new StringBuilder();
        sb.append("KEY\tVALUE\tTYPE\n");
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterTriplet pt = this.parameters.get(i);
            sb.append(pt.getName()).append("\t");
            sb.append(pt.getObject()).append("\t");
            sb.append(pt.getType()).append("\n");
        }
        return sb.toString();
    }

    public class ChildHandler
    extends ParameterTriplet {
        @Override
        public void complete() {
            ParameterTripletArray.this.parameters.add(this);
        }
    }
}

