/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix.calls;

import java.util.Map;
import uk.ac.ox.well.t2d.async.table.HeaderTableEntry;

public class AnnotationEntry
implements HeaderTableEntry {
    private String probeSetId;
    private String affySnpId;
    private String rsId;
    private String locType;
    private String chromosome;
    private String startPosition;
    private String endPosition;
    private String alleleA;
    private String alleleB;
    private boolean isValid;

    @Override
    public void set(long lineNumber, Map<String, String> recordData) throws Exception {
        this.setProbeSetId(recordData.get("Probe Set ID"));
        this.setAffySnpId(recordData.get("Affy SNP ID"));
        this.setRsId(recordData.get("dbSNP RS ID"));
        this.setLocType(recordData.get("dbSNP Loctype"));
        this.setChromosome(recordData.get("Chromosome"));
        this.setStartPosition(recordData.get("Physical Position"));
        this.setEndPosition(recordData.get("Position End"));
        this.setAlleleA(recordData.get("Allele A"));
        this.setAlleleB(recordData.get("Allele B"));
        this.validate();
    }

    @Override
    public void validate() throws Exception {
        if (null == this.getProbeSetId() || null == this.getAffySnpId() || null == this.getRsId() || null == this.getLocType() || null == this.getChromosome() || null == this.getStartPosition() || null == this.getEndPosition() || null == this.getAlleleA() || null == this.getAlleleB()) {
            throw new NullPointerException("One or more fields has not been set");
        }
        this.isValid = !"---".equals(this.getChromosome());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb, "\t");
        return sb.toString();
    }

    public StringBuilder toStringBuilder(String separator) {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb, separator);
        return sb;
    }

    public void toStringBuilder(StringBuilder sb, String separator) {
        sb.append(this.getProbeSetId()).append(separator).append(this.getAffySnpId()).append(separator).append(this.getRsId()).append(separator).append(this.getLocType()).append(separator).append(this.getChromosome()).append(separator).append(this.getStartPosition()).append(separator).append(this.getEndPosition()).append(separator).append(this.getAlleleA()).append(separator).append(this.getAlleleB());
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isTrueSnp() {
        return "2".equals(this.getLocType());
    }

    public void appendSnpInfo(StringBuilder sb) {
        sb.append(this.getChromosome()).append("\t");
        sb.append(this.getProbeSetId()).append("\t");
        sb.append("0").append("\t");
        sb.append(this.getStartPosition());
    }

    public void appendCallInfo(StringBuilder sb, char call) {
        switch (call) {
            case '0': {
                sb.append(this.getAlleleA()).append(" ").append(this.getAlleleA());
                break;
            }
            case '1': {
                sb.append(this.getAlleleA()).append(" ").append(this.getAlleleB());
                break;
            }
            case '2': {
                sb.append(this.getAlleleB()).append(" ").append(this.getAlleleB());
                break;
            }
            default: {
                sb.append("0 0");
            }
        }
    }

    public void appendChpCallInfo(StringBuilder sb, char call) {
        switch (call) {
            case '6': {
                sb.append(this.getAlleleA()).append(" ").append(this.getAlleleA());
                break;
            }
            case '7': {
                sb.append(this.getAlleleB()).append(" ").append(this.getAlleleB());
                break;
            }
            case '8': {
                sb.append(this.getAlleleA()).append(" ").append(this.getAlleleB());
                break;
            }
            default: {
                sb.append("0 0");
            }
        }
    }

    public String getProbeSetId() {
        return this.probeSetId;
    }

    public void setProbeSetId(String probeSetId) {
        this.probeSetId = probeSetId;
    }

    public String getAffySnpId() {
        return this.affySnpId;
    }

    public void setAffySnpId(String affySnpId) {
        this.affySnpId = affySnpId;
    }

    public String getRsId() {
        return this.rsId;
    }

    public void setRsId(String rsId) {
        this.rsId = rsId;
    }

    public String getLocType() {
        return this.locType;
    }

    public void setLocType(String locType) {
        this.locType = locType;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    public String getAlleleA() {
        return this.alleleA;
    }

    public void setAlleleA(String alleleA) {
        this.alleleA = alleleA;
    }

    public String getAlleleB() {
        return this.alleleB;
    }

    public void setAlleleB(String alleleB) {
        this.alleleB = alleleB;
    }

    public static class Header
    extends AnnotationEntry {
        @Override
        public void toStringBuilder(StringBuilder sb, String separator) {
            sb.append("Probe Set ID").append(separator).append("Affy SNP ID").append(separator).append("dbSNP RS ID").append(separator).append("dbSNP Loctype").append(separator).append("Chromosome").append(separator).append("Physical Position").append(separator).append("Position End").append(separator).append("Allele A").append(separator).append("Allele B");
        }
    }
}

