/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix.calls;

import java.util.Collection;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.calls.AffyProperties;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.calls.AnnotationEntry;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.table.HeaderTableEntry;
import uk.ac.ox.well.t2d.async.table.HeaderTableHandler;
import uk.ac.ox.well.t2d.async.table.HeaderTableLoader;
import uk.ac.ox.well.t2d.async.table.MapHandler;

public class AnnotationLoader
extends HeaderTableLoader {
    @Override
    protected HeaderTableEntry newEntry() {
        return new AnnotationEntry();
    }

    @Override
    protected TableParsingLogic newLogic() {
        CsvParsingLogic logic = new CsvParsingLogic();
        logic.setCellSeparator(',');
        return logic;
    }

    @Override
    protected TableCellHandler<Collection> newHandler() {
        return new AnnotationHandler(new HeaderTableLoader.HeaderTableEntryHandler(this));
    }

    public CharArraySequence removeQuotes(CharArraySequence cas) {
        boolean substring = false;
        int from = 0;
        int to = cas.length();
        if (cas.charAt(from) == '\"') {
            from = 1;
            substring = true;
        }
        if (cas.charAt(to - 1) == '\"') {
            --to;
            substring = true;
        }
        if (substring) {
            return cas.subSequence(from, to);
        }
        return cas;
    }

    public class AnnotationHandler
    extends HeaderTableHandler {
        boolean isCommentLine;

        public AnnotationHandler(MapHandler mh) {
            super(mh);
            this.isCommentLine = false;
        }

        @Override
        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket bo) throws Exception {
            CharArraySequence cleanCellData = AnnotationLoader.this.removeQuotes(cellData);
            if (this.isCommentLine) {
                if (meta.isEndOfLine()) {
                    this.isCommentLine = false;
                }
                return false;
            }
            if (1L == meta.getColumnNumber()) {
                if (AffyProperties.isCommentPrefix(cleanCellData)) {
                    this.isCommentLine = true;
                    if (meta.isEndOfLine()) {
                        this.isCommentLine = false;
                    }
                    return false;
                }
                return super.cell(meta, cleanCellData, bo);
            }
            return super.cell(meta, cleanCellData, bo);
        }
    }
}

