/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix.calls;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.calls.AffyProperties;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.calls.AnnotationEntry;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.processors.NullPayloadManager;

public class CallTransformer
extends TableParser<CharBuffer> {
    public static final String COMMENT_DATA = "AffyCallTransformer.CommentData";
    public static final String HEADER_LINE = "AffyCallTransformer.HeaderLine";
    protected int charMaxGuide = 500000;
    protected boolean trueSnpsOnly = false;
    protected boolean annotationAndHeaderOnly = false;

    public CallTransformer() {
        this.setPayloadManager(new NullPayloadManager());
    }

    public CallTransformer setCharMaxGuide(int i) {
        this.charMaxGuide = i;
        return this;
    }

    public CallTransformer setTrueSnpsOnly(boolean b) {
        this.trueSnpsOnly = b;
        return this;
    }

    public CallTransformer setAnnotationAndHeaderOnly(boolean b) {
        this.annotationAndHeaderOnly = b;
        return this;
    }

    @Override
    protected TableParsingLogic newLogic() {
        CsvParsingLogic logic = new CsvParsingLogic();
        return logic;
    }

    @Override
    protected TableCellHandler<CharBuffer> newHandler() {
        return new CallHandler();
    }

    public class CallHandler
    extends TableCellHandlerBase<CharBuffer> {
        StringBuilder sb;
        List<String> commentData;
        List<String> headerLine;
        boolean isHeaderLine;
        Map<String, AnnotationEntry> annotationMap;
        AnnotationEntry snpAnnotation;

        public CallHandler() {
            this.sb = new StringBuilder(CallTransformer.this.charMaxGuide);
            this.isHeaderLine = false;
            this.commentData = new ArrayList<String>();
        }

        @Override
        public boolean startTable(Bucket<CharBuffer> bo) throws Exception {
            this.annotationMap = (Map)this.getContractMetadata("affy_annotation_map");
            if (null == this.annotationMap) {
                throw new RequiredPropertyValueNotFound("affy_annotation_map");
            }
            this.commentData = new ArrayList<String>();
            this.headerLine = new ArrayList<String>();
            this.isHeaderLine = false;
            return false;
        }

        @Override
        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket<CharBuffer> bo) throws Exception {
            if (this.isHeaderLine) {
                this.headerLine.add(cellData.toString());
                if (meta.isEndOfLine()) {
                    this.isHeaderLine = false;
                }
                return false;
            }
            if (1L == meta.getColumnNumber()) {
                if (AffyProperties.isCommentPrefix(cellData)) {
                    this.commentData.add(cellData.toString());
                    return false;
                }
                if (cellData.equalsCharSeq("probeset_id")) {
                    this.isHeaderLine = true;
                    this.headerLine.add(cellData.toString());
                    if (meta.isEndOfLine()) {
                        this.isHeaderLine = false;
                    }
                    return false;
                }
                String id = cellData.toString().trim();
                this.snpAnnotation = this.annotationMap.get(id);
                if (null == this.snpAnnotation) {
                    throw new RuntimeException("Found unknown Affymetrix probe id: " + id);
                }
                if (this.isSnpRequired()) {
                    this.snpAnnotation.appendSnpInfo(this.sb);
                }
                return false;
            }
            if (!this.isSnpRequired()) {
                return false;
            }
            char call = cellData.charAt(0);
            this.sb.append("\t");
            this.snpAnnotation.appendCallInfo(this.sb, call);
            if (meta.isEndOfLine()) {
                this.sb.append("\n");
            }
            if (this.sb.length() >= CallTransformer.this.charMaxGuide) {
                CharBuffer cb = this.toCharBuffer();
                bo.setPayload(cb);
                return true;
            }
            return false;
        }

        protected boolean isSnpRequired() {
            if (CallTransformer.this.annotationAndHeaderOnly) {
                return false;
            }
            if (!this.snpAnnotation.isValid()) {
                return false;
            }
            return !CallTransformer.this.trueSnpsOnly || this.snpAnnotation.isTrueSnp();
        }

        @Override
        public boolean endTable(Bucket<CharBuffer> bo) throws Exception {
            CharBuffer cb = this.toCharBuffer();
            bo.setPayload(cb);
            this.getContract().put(CallTransformer.COMMENT_DATA, this.commentData);
            this.getContract().put(CallTransformer.HEADER_LINE, this.headerLine);
            this.commentData = null;
            this.headerLine = null;
            return false;
        }

        public CharBuffer toCharBuffer() {
            CharBuffer cb = CharBuffer.wrap(this.sb.toString());
            this.sb.setLength(0);
            return cb;
        }
    }
}

