/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.processors.PayloadMulticaster;

public class ArrayBranch
implements Processor {
    public Map<String, Context> cxtMap = new LinkedHashMap<String, Context>();
    protected List<Processor> processorList = new ArrayList<Processor>();

    public void addProcessor(Processor p) {
        this.processorList.add(p);
    }

    public List<Processor> getProcessors() {
        return Collections.unmodifiableList(this.processorList);
    }

    @Override
    public void commence() {
        for (Processor p : this.processorList) {
            p.commence();
        }
    }

    @Override
    public void close() {
        for (Processor p : this.processorList) {
            p.close();
        }
        this.cxtMap.clear();
        this.processorList.clear();
    }

    public void consume(Contract c, Bucket bin, boolean endOfStream) {
        Context cxt = this.getContext(c);
        cxt.multiplex(bin, endOfStream);
        if (endOfStream) {
            this.removeContext(c);
        }
    }

    protected synchronized Context getContext(Contract parent) {
        Context cxt = this.cxtMap.get(parent.getId());
        if (null == cxt) {
            cxt = this.newContext(parent);
            this.cxtMap.put(parent.getId(), cxt);
        }
        return cxt;
    }

    protected Context newContext(Contract parent) {
        return new Context(parent);
    }

    protected synchronized void removeContext(Contract parent) {
        this.cxtMap.remove(parent.getId());
    }

    public PayloadMulticaster newPayloadMulticaster(Bucket b, int i) {
        return new ObjectArrayMulticaster(b, i);
    }

    public static class ObjectArrayMulticaster
    extends PayloadMulticaster {
        public ObjectArrayMulticaster(Bucket b, int count) {
            super(b, count);
        }

        protected Object multiplexPayload(Object p, int i) {
            Object[] os = (Object[])p;
            return os[i];
        }
    }

    protected class Context {
        List<Contract> subContracts = new ArrayList<Contract>();

        public Context(Contract parent) {
            ContractGroup grp = new ContractGroup(parent);
            for (int i = 0; i < ArrayBranch.this.processorList.size(); ++i) {
                ContractGroup.SiblingContract sub = grp.newContract(false);
                this.subContracts.add(sub);
            }
            grp.setFinalize();
        }

        public void multiplex(Bucket<Object[]> bin, boolean endOfStream) {
            Object[] oa = bin.getPayload();
            if (oa.length != ArrayBranch.this.processorList.size()) {
                Formatter f = new Formatter();
                f.format("Mismatch when Multiplexing array data. Expecting input for %s Processors, but found an Input Array of length %s.", ArrayBranch.this.processorList.size(), oa.length);
                throw new RuntimeException(f.toString());
            }
            PayloadMulticaster pm = ArrayBranch.this.newPayloadMulticaster(bin, oa.length);
            Iterator cit = pm.iterator();
            for (int i = 0; i < oa.length; ++i) {
                Bucket cb = cit.next();
                ArrayBranch.this.processorList.get(i).consume(this.subContracts.get(i), cb, endOfStream);
            }
        }
    }
}

