/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix.tools;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.calls.AnnotationEntry;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.ped.WhiteSpaceParsingLogic;

public class ChpExtractTransformer
extends TableParser {
    public static final String PROBE_LIST = "ChpExtractTransformer.PROBE_LIST";
    public static final String IND_LIST = "ChpExtractTransformer.IND_LIST";

    protected TableParsingLogic newLogic() {
        return new WhiteSpaceParsingLogic();
    }

    protected TableCellHandler newHandler() {
        return new ChipExtractHandler();
    }

    public class ChipExtractHandler
    extends TableCellHandlerBase<Object[]> {
        List<String> indList;
        List<String> probeList;
        StringBuilder alleleData = new StringBuilder(10000);
        StringBuilder xyData = new StringBuilder(10000);
        Map<String, AnnotationEntry> annotationMap;
        AnnotationEntry snpAnnotation;

        public int getBufferSize() {
            int i = 0;
            i += this.alleleData.length();
            i += this.xyData.length();
            return i *= 2;
        }

        @Override
        public boolean startTable(Bucket<Object[]> bo) throws Exception {
            this.indList = new ArrayList<String>(10000);
            this.probeList = new ArrayList<String>(100000);
            this.annotationMap = (Map)this.getContractMetadata("affy_annotation_map");
            if (null == this.annotationMap) {
                throw new RequiredPropertyValueNotFound("affy_annotation_map");
            }
            this.alleleData.setLength(0);
            this.xyData.setLength(0);
            return false;
        }

        @Override
        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket<Object[]> bo) throws Exception {
            if (1L == meta.getColumnNumber()) {
                this.handleIid(meta, cellData);
            } else {
                int mod = (int)((meta.getColumnNumber() - 2L) % 6L);
                switch (mod) {
                    case 0: {
                        this.handleProbeSetName(meta, cellData);
                        break;
                    }
                    case 1: {
                        this.handleCall(meta, cellData);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.xyData.append("\t").append(cellData);
                        break;
                    }
                    case 4: {
                        this.xyData.append(" ").append(cellData);
                        break;
                    }
                }
            }
            if (meta.isEndOfLine()) {
                this.alleleData.append("\n");
                this.xyData.append("\n");
                if (ChpExtractTransformer.this.getBufferCapacity() < this.getBufferSize()) {
                    this.setPayload(bo);
                    return true;
                }
                return false;
            }
            return false;
        }

        public void handleIid(TableCellMetadata meta, CharArraySequence cellData) {
            String iid = cellData.toString().trim();
            this.indList.add(iid);
            this.alleleData.append(iid);
            this.xyData.append(iid);
        }

        public void handleProbeSetName(TableCellMetadata meta, CharArraySequence cellData) {
            String snp = cellData.toString();
            if (1L == meta.getLineNumber()) {
                this.probeList.add(snp);
            }
            this.snpAnnotation = this.annotationMap.get(snp);
            if (null == this.snpAnnotation) {
                throw new RuntimeException("Found unknown Affymetrix probe id: " + snp);
            }
        }

        public void handleCall(TableCellMetadata meta, CharArraySequence cellData) {
            char call = cellData.charAt(0);
            this.alleleData.append("\t");
            this.snpAnnotation.appendChpCallInfo(this.alleleData, call);
        }

        @Override
        public boolean endTable(Bucket<Object[]> bo) throws Exception {
            this.setPayload(bo);
            this.getContract().put(ChpExtractTransformer.IND_LIST, this.indList);
            this.getContract().put(ChpExtractTransformer.PROBE_LIST, this.probeList);
            return false;
        }

        public void setPayload(Bucket<Object[]> bo) {
            CharBuffer[] array = new CharBuffer[]{this.toCharBuffer(this.alleleData), this.toCharBuffer(this.xyData)};
            bo.setPayload(array);
        }

        public CharBuffer toCharBuffer(StringBuilder sb) {
            CharBuffer cb = CharBuffer.wrap(sb.toString());
            sb.setLength(0);
            return cb;
        }
    }
}

