/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix.tools;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataFileHandler;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataFileParser;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.GenericDataSet;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class DataSetExtractor
extends AbstractConveyor<Context, ByteBuffer, CharBuffer> {
    protected String defaultDataGroupName;
    protected String defaultDataSetName;

    public DataSetExtractor setDataGroupName(String str) {
        this.defaultDataGroupName = str;
        return this;
    }

    public DataSetExtractor setDataSetName(String str) {
        this.defaultDataSetName = str;
        return this;
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    public class Context
    extends ProcessingContext<ByteBuffer, CharBuffer>
    implements GenericDataFileHandler {
        protected GenericDataFileParser parser = new GenericDataFileParser();
        protected String dataGroupName;
        protected String dataSetName;
        protected StringBuilder builder;

        @Override
        public void initialize() {
            this.dataGroupName = (String)this.getContract().get("AffyProperties.AFFY_DATAGROUP_NAME");
            if (null == this.dataGroupName) {
                if (null == DataSetExtractor.this.defaultDataGroupName) {
                    throw new RequiredPropertyValueNotFound("AffyProperties.AFFY_DATAGROUP_NAME");
                }
                this.dataGroupName = DataSetExtractor.this.defaultDataGroupName;
            }
            this.dataSetName = (String)this.getContract().get("AffyProperties.AFFY_DATASET_NAME");
            if (null == this.dataSetName) {
                if (null == DataSetExtractor.this.defaultDataSetName) {
                    throw new RequiredPropertyValueNotFound("AffyProperties.AFFY_DATASET_NAME");
                }
                this.dataSetName = DataSetExtractor.this.defaultDataSetName;
            }
            this.builder = new StringBuilder();
            this.parser.setHandler(this);
            this.parser.initialize();
        }

        @Override
        public void clear() {
            this.builder = null;
            this.dataGroupName = null;
            this.dataSetName = null;
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<CharBuffer> po, boolean endOfContract) throws Exception {
            while (pi.hasRemaining()) {
                this.parser.next(pi.get());
            }
            if (endOfContract) {
                this.builder.append("\n");
                po.setPayload(CharBuffer.wrap(this.builder));
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        @Override
        public void handleData(GenericDataSet set, Object[] rowData) {
            if (set.getGroup().getName().equals(this.dataGroupName) && set.getName().equals(this.dataSetName)) {
                for (int i = 0; i < rowData.length; ++i) {
                    if (0 != this.builder.length()) {
                        this.builder.append("\t");
                    }
                    this.builder.append(rowData[i]);
                }
            }
            System.out.flush();
        }
    }
}

