/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix.tools;

import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.Demultiplexer;
import uk.ac.ox.well.t2d.async.contracts.ParallelMultiplexer;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.contracts.Resequencer;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.tools.DataSetExtractor;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.io.PathScanner;
import uk.ac.ox.well.t2d.async.io.working.FileWriteResultUnpacker;
import uk.ac.ox.well.t2d.async.io.working.WorkingPathBuilder;
import uk.ac.ox.well.t2d.async.io.working.WorkingPathDeletor;
import uk.ac.ox.well.t2d.async.metadata.FileLdrBlock;
import uk.ac.ox.well.t2d.async.metadata.FileWrtrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.processors.BucketBase;
import uk.ac.ox.well.t2d.async.processors.CollectionSerializer;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class DataSetExtractorBlck
extends SubSection {
    protected static final Pattern CEL_FILE_PATTERN = Pattern.compile("([\\w-]*).CEL");
    protected PathScanner scanner;
    protected NameExtractor nameExtractor;
    protected DataSetExtractor dataSetExtractor;

    public DataSetExtractorBlck() {
        super(false);
        this.addProcessor(new MetadataReader().setIsRequired(true).setPropertyKey("IOProperties.IN_DIRECTORY"));
        this.scanner = new PathScanner();
        this.addProcessor(this.scanner);
        this.addProcessor(new CollectionSerializer());
        this.addProcessor(new ParallelMultiplexer());
        this.nameExtractor = new NameExtractor();
        this.addProcessor(this.nameExtractor);
        this.addProcessor(new FileLdrBlock.Binary());
        this.dataSetExtractor = new DataSetExtractor();
        this.addProcessor(this.dataSetExtractor);
        this.addProcessor(new SampleNameLeader());
        this.addProcessor(new WorkingPathBuilder());
        this.addProcessor(new FileWrtrBlock.CharWrtr());
        this.addProcessor(new Resequencer());
        this.addProcessor(new Demultiplexer());
        this.addProcessor(new FileWriteResultUnpacker());
        this.addProcessor(new ParallelMultiplexer());
        FileLdrBlock.Binary fileLoader = new FileLdrBlock.Binary();
        fileLoader.getPathFinder().setDepth(1);
        fileLoader.setContractSyncDepth(1);
        this.addProcessor(fileLoader);
        this.addProcessor(new WorkingPathDeletor());
        this.addProcessor(new Demultiplexer());
        this.addProcessor(new FileWrtrBlock());
    }

    public PathScanner getPathScanner() {
        return this.scanner;
    }

    public NameExtractor getNameExtractor() {
        return this.nameExtractor;
    }

    public DataSetExtractor getDataExtractor() {
        return this.dataSetExtractor;
    }

    public class SampleNameLeader
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            String str = (String)c.get("IOProperties.OUT_PREFIX");
            str = str + "\t";
            BucketBase<CharBuffer> bb = new BucketBase<CharBuffer>();
            bb.setPayload(CharBuffer.wrap(str));
            this.p.consume(c, bb, false);
            this.p.consume(c, bin, endOfInput);
        }
    }

    public class NameExtractor
    extends BasicProcessor {
        protected Pattern pattern;

        public NameExtractor setPattern(Pattern p) {
            this.pattern = p;
            return this;
        }

        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            String iid;
            if (null == this.pattern) {
                throw new RuntimeException("Pattern not set before initialization as required.");
            }
            Object o = bin.getPayload();
            if (null == o) {
                iid = "UNKNOWN";
            } else {
                Matcher m = this.pattern.matcher(o.toString());
                m.find();
                iid = m.group(1);
            }
            c.put("IOProperties.OUT_PREFIX", iid);
            this.p.consume(c, bin, endOfInput);
        }
    }

    public static class Rig
    extends ExecutionRig {
        DataSetExtractorBlck blck = new DataSetExtractorBlck();

        @Override
        public PrimaryContract execute() throws Exception {
            return this.execute(this.blck);
        }

        public DataSetExtractorBlck getBlock() {
            return this.blck;
        }
    }
}

