/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.bed;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import uk.ac.ox.well.t2d.async.genotype.bed.BedWriter;
import uk.ac.ox.well.t2d.async.genotype.bed.IndexedBedMetadata;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;

public class BedExtractor
extends IndexedBedMetadata {
    private ByteBuffer buffer;

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public BedWriter getBimEntry(BimEntry be) {
        BedWriter bw = this.newSnpMajorSubset(be);
        for (FamEntry fe : this.getFamList()) {
            BedConstants.Call c = this.getSnpMajorCall(be, fe);
            bw.writeCall(fe, be, c);
        }
        return bw;
    }

    public BedWriter getFamEntry(FamEntry fe) {
        BedWriter bw = this.newIndMajorSubset(fe);
        for (BimEntry be : this.getBimList()) {
            BedConstants.Call c = this.getIndMajorCall(fe, be);
            bw.writeCall(fe, be, c);
        }
        return bw;
    }

    public BedConstants.Call getSnpMajorCall(BimEntry be, FamEntry fe) {
        int bidx = this.getByteIndex(be.getIndex(), fe.getIndex());
        byte b = this.buffer.get(bidx);
        int off = this.getByteOffset(fe.getIndex());
        return this.getCall(off, b);
    }

    public BedConstants.Call getIndMajorCall(FamEntry fe, BimEntry be) {
        int bidx = this.getByteIndex(fe.getIndex(), be.getIndex());
        byte b = this.buffer.get(bidx);
        int off = this.getByteOffset(be.getIndex());
        return this.getCall(off, b);
    }

    public BedWriter newSnpMajorSubset(BimEntry be) {
        BedWriter bw = new BedWriter();
        BimEntry nbe = new BimEntry(be);
        nbe.setIndex(0);
        ArrayList<BimEntry> bel = new ArrayList<BimEntry>();
        bw.setBimList(bel);
        bw.setFamList(this.getFamList());
        bw.setOrder(BedConstants.Order.SNP_MAJOR);
        return bw;
    }

    public BedWriter newIndMajorSubset(FamEntry fe) {
        BedWriter bw = new BedWriter();
        FamEntry nfe = new FamEntry(fe);
        nfe.setIndex(0);
        ArrayList<FamEntry> fel = new ArrayList<FamEntry>();
        bw.setFamList(fel);
        bw.setBimList(this.getBimList());
        bw.setOrder(BedConstants.Order.IND_MAJOR);
        return bw;
    }
}

