/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.bed;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.metadata.FileWrtrBlock;
import uk.ac.ox.well.t2d.async.metadata.PropertyReporter;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedParsingContext;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.ped.rig.BedDataLoader;
import uk.ac.ox.well.t2d.async.ped.tools.GenotypeIndex;
import uk.ac.ox.well.t2d.async.ped.tools.MinorAlleleGenotype;
import uk.ac.ox.well.t2d.async.ped.tools.MinorAlleleGenotypeLdrBlck;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class BedGenotypeFinder
extends AbstractConveyor<BedContext, ByteBuffer, CharBuffer> {
    @Override
    protected BedContext newContext() {
        return new BedContext();
    }

    public static class Rig
    extends ExecutionRig {
        @Override
        public PrimaryContract execute() throws Exception {
            SeriesBlock sb = new SeriesBlock();
            sb.addProcessor(new MinorAlleleGenotypeLdrBlck());
            sb.addProcessor(new PropertyReporter.CollectionRprtr().setIsRequired(true).setKey("MinorAlleleGenotype.List").setLabel("MinorAlleleReport"));
            sb.addProcessor(new MinorAlleleGenotypeLdrBlck.MinorAlleleGenotypeIndexer());
            sb.addProcessor(new BedDataLoader());
            BedGenotypeFinder bp = new BedGenotypeFinder();
            sb.addProcessor(bp);
            sb.addProcessor(new FileWrtrBlock.CharWrtr());
            return this.execute(sb);
        }
    }

    public class BedContext
    extends BedParsingContext<CharBuffer> {
        boolean isHeaderWritten;
        GenotypeIndex idx;
        StringBuilder builder = new StringBuilder();

        @Override
        public void initialize() throws Exception {
            super.initialize();
            this.idx = (GenotypeIndex)this.getContract().get("MinorAlleleGenotype.Index");
            if (null == this.idx) {
                throw new RequiredPropertyValueNotFound("MinorAlleleGenotype.Index");
            }
        }

        @Override
        public void clear() {
            this.builder.setLength(0);
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<CharBuffer> po, boolean endOfContract) throws Exception {
            while (pi.hasRemaining()) {
                this.handleByte(pi.get());
            }
            if (0 != this.builder.length()) {
                po.setPayload(this.toCharBuffer());
            }
            return ProcessingResult.BOTH_COMPLETE;
        }

        @Override
        public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
            BimEntry bim = this.meta.getBimList().get(snpIndex);
            FamEntry fam = this.meta.getFamList().get(sampleIndex);
            MinorAlleleGenotype mag = (MinorAlleleGenotype)this.idx.get(bim.getChromosome(), bim.getPosition(), fam.getIndividualId());
            if (null != mag) {
                this.writeHeader(this.builder);
                this.builder.append(mag.toString());
                this.builder.append("\t");
                this.builder.append(bim.toString(call).replaceAll(" ", ""));
                this.builder.append("\n");
            }
        }

        public void writeHeader(StringBuilder reg) {
            if (!this.isHeaderWritten) {
                reg.append(new MinorAlleleGenotype.Header().toString());
                reg.append("\t");
                reg.append("BED_ALLELES");
                reg.append("\n");
            }
            this.isHeaderWritten = true;
        }

        public CharBuffer toCharBuffer() {
            CharBuffer cb = CharBuffer.wrap(this.builder.toString());
            this.builder.setLength(0);
            return cb;
        }
    }
}

