/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.bed;

import java.nio.ByteBuffer;
import uk.ac.ox.well.t2d.async.genotype.bed.IndexedBedMetadata;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedHandler;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;

public class BedWriter
extends IndexedBedMetadata
implements BedHandler<ByteBuffer> {
    protected ByteBuffer bb;
    protected int majorOffset = 0;

    @Override
    public void initialize() {
        super.initialize();
        this.bb = ByteBuffer.allocateDirect(this.calcRequiredBufferSize());
    }

    @Override
    public void handleCall(FamEntry fe, BimEntry be, BedConstants.Call cl, ByteBuffer bo) {
        this.writeCall(fe, be, cl);
    }

    public void writeCall(FamEntry fe, BimEntry be, BedConstants.Call cl) {
        int minIdx;
        int majIdx;
        FamEntry newFe = (FamEntry)this.famIdx.get(fe.getId());
        BimEntry newBe = (BimEntry)this.bimIdx.get(be.getId());
        if (this.getOrder().equals((Object)BedConstants.Order.SNP_MAJOR)) {
            majIdx = newBe.getIndex();
            minIdx = newFe.getIndex();
        } else {
            minIdx = newBe.getIndex();
            majIdx = newFe.getIndex();
        }
        int bidx = this.getByteIndex(majIdx -= this.majorOffset, minIdx);
        byte b = this.bb.get(bidx);
        int off = this.getByteOffset(minIdx);
        b = this.setCall(cl, off, b);
        this.bb.put(bidx, b);
    }

    public ByteBuffer getBytes() {
        return this.bb;
    }
}

