/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.bed;

import java.nio.ByteBuffer;
import java.util.List;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.genotype.bed.BedWriter;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.GenotypeProperties;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedParsingContext;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class SimpleBedTransformer
extends AbstractConveyor<Context, ByteBuffer, ByteBuffer> {
    @Override
    protected Context newContext() {
        return new Context();
    }

    public class Context
    extends BedParsingContext<ByteBuffer> {
        protected BedWriter handler;

        @Override
        public void initialize() throws Exception {
            super.initialize();
            this.handler = new BedWriter();
            List beList = (List)this.getContract().get("BedConstants.OutBimList");
            if (null == beList) {
                throw new RuntimeException("No Output Bim List Specified.");
            }
            this.handler.setBimList(beList);
            List feList = (List)this.getContract().get("BedConstants.OutFamList");
            if (null == feList) {
                throw new RuntimeException("No Output Fam List Specified.");
            }
            this.handler.setFamList(feList);
            BedConstants.Order ord = GenotypeProperties.orderValueOf(this.getContract(), "gt_output_order");
            if (null == ord) {
                throw new RuntimeException("No Output Order Specified.");
            }
            this.handler.setOrder(ord);
        }

        @Override
        public void clear() {
            this.handler = null;
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<ByteBuffer> po, boolean endOfContract) throws Exception {
            while (pi.hasRemaining()) {
                this.handleByte(pi.get());
            }
            if (endOfContract) {
                po.setPayload(this.handler.getBytes());
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        @Override
        public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
            BimEntry bim = this.meta.getBimList().get(snpIndex);
            FamEntry fam = this.meta.getFamList().get(sampleIndex);
            this.handler.handleCall(fam, bim, call, null);
        }
    }
}

