/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.bed;

import java.nio.ByteBuffer;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.genotype.bed.SimpleBedTransformer;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.metadata.FileWrtrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.metadata.PropertyDeletor;
import uk.ac.ox.well.t2d.async.metadata.PropertyInjector;
import uk.ac.ox.well.t2d.async.parser.rig.ListWriterBlock;
import uk.ac.ox.well.t2d.async.parser.rig.OutputPathBuilder;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedMetadata;
import uk.ac.ox.well.t2d.async.ped.rig.BedDataLoader;
import uk.ac.ox.well.t2d.async.processors.BucketBase;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class SimpleBedTransformerBlck
extends SubSection {
    public SimpleBedTransformerBlck() {
        super(false);
        this.addProcessor(new BedDataLoader());
        this.addProcessor(new BimFamPutter());
        this.addProcessor(new SimpleBedTransformer());
        this.addProcessor(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("bed"));
        this.addProcessor(new OutputPathBuilder());
        this.addProcessor(new HeaderPutter());
        this.addProcessor(new FileWrtrBlock());
        this.addProcessor(new MetadataReader().setIsRequired(true).setPropertyKey("BedConstants.OutBimList"));
        this.addProcessor(new PropertyDeletor().setKey("IOProperties.OUT_PATH"));
        this.addProcessor(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("bim"));
        this.addProcessor(new OutputPathBuilder());
        this.addProcessor(new ListWriterBlock());
        this.addProcessor(new MetadataReader().setIsRequired(true).setPropertyKey("BedConstants.OutFamList"));
        this.addProcessor(new PropertyDeletor().setKey("IOProperties.OUT_PATH"));
        this.addProcessor(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("fam"));
        this.addProcessor(new OutputPathBuilder());
        this.addProcessor(new ListWriterBlock());
    }

    public class HeaderPutter
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            BucketBase<ByteBuffer> bb = new BucketBase<ByteBuffer>();
            byte[] header = new byte[]{108, 27, 1};
            bb.setPayload(ByteBuffer.wrap(header));
            this.p.consume(c, bb, false);
            this.p.consume(c, bin, endOfInput);
        }
    }

    public class BimFamPutter
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            if (!c.containsKey("BedConstants.OutBimList")) {
                BedMetadata bm = (BedMetadata)c.get("BedParsingContext.BedMetadataIn");
                c.put("BedConstants.OutBimList", bm.getBimList());
                c.put("BedConstants.OutFamList", bm.getFamList());
                c.put("gt_output_order", BedConstants.Order.SNP_MAJOR.toString());
            }
            this.p.consume(c, bin, endOfInput);
        }
    }

    public static class Rig
    extends ExecutionRig {
        @Override
        public PrimaryContract execute() throws Exception {
            return this.execute(new SimpleBedTransformerBlck());
        }
    }
}

