/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.Demultiplexer;
import uk.ac.ox.well.t2d.async.contracts.ParallelMultiplexer;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.plot.ClusterPlot;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.plot.ClusterPlotGenerator;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.plot.ClusterPlotter;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelWriter;
import uk.ac.ox.well.t2d.async.io.CharacterEncoder;
import uk.ac.ox.well.t2d.async.io.IOProperties;
import uk.ac.ox.well.t2d.async.processors.CollectionSerializer;

public class ClstrPlttrBlock
extends SubSection {
    public static final String ALLELE_DATA_KEY = "ClusterPlot.alleles";
    public static final String XY_DATA_KEY = "ClusterPlot.XY";
    public static final String PLOT_EXCLUDED_KEY = "ClusterPlot.PlotExcluded";
    public static final String PLOT_FORMAT_KEY = "ClusterPlot.PlotFormat";
    public static final String HTML_FORMAT = "HTML";

    @Override
    public void commence() {
        super.addProcessor(new ClusterPlotGenerator());
        super.addProcessor(new CollectionSerializer());
        super.addProcessor(new ParallelMultiplexer());
        super.addProcessor(new ClsterPltPthFormatter());
        super.addProcessor(new ClusterPlotter());
        super.addProcessor(new CharacterEncoder());
        super.addProcessor(new AsynchronousFileChannelWriter());
        super.addProcessor(new Demultiplexer());
        super.commence();
    }

    public class ClsterPltPthFormatter
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            String dirStr = (String)c.get("IOProperties.OUT_DIRECTORY");
            if (null == dirStr) {
                throw new RuntimeException("No Out Directory Path found!!");
            }
            String formatStr = (String)c.get(ClstrPlttrBlock.PLOT_FORMAT_KEY);
            boolean plotHtml = false;
            if (null != formatStr && ClstrPlttrBlock.HTML_FORMAT.equalsIgnoreCase(formatStr)) {
                plotHtml = true;
            }
            Path dirPath = null;
            try {
                Path baseDir = IOProperties.getBaseDir(c);
                dirPath = IOProperties.toPath(baseDir, dirStr);
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ClusterPlot plot = (ClusterPlot)bin.getPayload();
            StringBuilder sb = new StringBuilder();
            sb.append(plot.getId());
            if (plot.getMetadata().containsKey("FilterLabel")) {
                sb.append(".");
                sb.append(plot.getMetadata().get("FilterLabel"));
            }
            if (plotHtml) {
                sb.append(".html");
            } else {
                sb.append(".svg");
            }
            Path path = dirPath.resolve(sb.toString());
            c.put("IOProperties.OUT_PATH", path);
            this.getProcessor().consume(c, bin, endOfInput);
        }
    }
}

