/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import java.nio.ByteBuffer;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.genotype.matrix.DuplicateLogic;
import uk.ac.ox.well.t2d.async.genotype.matrix.GenotypeMatrixSubset;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedHandler;
import uk.ac.ox.well.t2d.async.ped.BedParsingContext;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class ClusterPlotBedLoader
extends AbstractConveyor<Context, ByteBuffer, GenotypeMatrixSubset> {
    @Override
    protected Context newContext() {
        return new Context();
    }

    public class ClstrBedHandler
    implements BedHandler<GenotypeMatrixSubset> {
        @Override
        public void handleCall(FamEntry fe, BimEntry be, BedConstants.Call cl, GenotypeMatrixSubset gd) {
            String[] alleles = be.toArray(cl);
            gd.handleCell(be.getSnpId(), fe.getIndividualId(), 0, alleles[0], null);
            gd.handleCell(be.getSnpId(), fe.getIndividualId(), 1, alleles[1], null);
        }
    }

    public class Context
    extends BedParsingContext<GenotypeMatrixSubset> {
        protected ClstrBedHandler handler;
        protected GenotypeMatrixSubset gtd = null;

        public Context() {
            this.handler = new ClstrBedHandler();
        }

        @Override
        public void initialize() throws Exception {
            super.initialize();
            this.gtd = new GenotypeMatrixSubset();
            DuplicateLogic.Rule rule = DuplicateLogic.ruleValueOf(this.getContract(), "DuplicateLogic.Rule");
            if (null != rule) {
                this.gtd.setDuplicateRule(rule);
            }
            this.gtd.initialize(this.getContract());
        }

        @Override
        public void clear() {
            this.gtd = null;
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<GenotypeMatrixSubset> po, boolean endOfContract) throws Exception {
            while (pi.hasRemaining()) {
                this.handleByte(pi.get());
            }
            if (endOfContract) {
                po.setPayload(this.gtd);
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        @Override
        public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
            BimEntry bim = this.meta.getBimList().get(snpIndex);
            FamEntry fam = this.meta.getFamList().get(sampleIndex);
            this.handler.handleCall(fam, bim, call, this.gtd);
        }
    }
}

