/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.matrix.GenotypeMatrixHandler;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;

public abstract class GenotypeTableHandler<PO>
extends TableCellHandlerBase<PO> {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenotypeTableHandler.class);
    public static final String ROW_OFFSET_KEY = "GenotypeTableHandler.RowOffset";
    public static final String COLUMN_OFFSET_KEY = "GenotypeTableHandler.ColumnOffset";
    protected int rowOffset = 0;
    protected int columnOffset = 0;
    protected int subfieldCount = 2;
    protected GenotypeMatrixHandler cellHandler;

    public GenotypeTableHandler setSubfieldCount(int sfc) {
        this.subfieldCount = sfc;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.columnOffset = 0;
        this.rowOffset = 0;
        this.subfieldCount = 2;
    }

    @Override
    public boolean startTable(Bucket<PO> bo) throws Exception {
        this.initialize();
        return super.startTable(bo);
    }

    @Override
    public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        int majIdx = (int)meta.getLineNumber() - 1;
        int colIdx = (int)meta.getColumnNumber() - 1;
        if (0 <= (majIdx -= this.rowOffset) && 0 <= (colIdx -= this.columnOffset)) {
            int minIdx = colIdx / this.subfieldCount;
            int subfieldPosition = colIdx % this.subfieldCount;
            return this.cellHandler.cell(majIdx, minIdx, subfieldPosition, cellData, bo);
        }
        return false;
    }

    public void initialize() {
        Object rowOff;
        Contract c = this.getContract();
        Object colOff = c.get(COLUMN_OFFSET_KEY);
        if (null != colOff) {
            this.columnOffset = Integer.parseInt(colOff.toString());
        }
        if (null != (rowOff = c.get(ROW_OFFSET_KEY))) {
            this.rowOffset = Integer.parseInt(rowOff.toString());
        }
        if (0 != this.rowOffset || 0 != this.columnOffset) {
            String msg = String.format("Parsing Genotype Table with row offset %d & column offset %d", this.rowOffset, this.columnOffset);
            LOGGER.info(msg);
        }
    }
}

