/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import java.util.List;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.IndexLoaderBlock;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;

public class IndSnpIdxLdrBlock
extends SeriesBlock {
    public static final String SNP_INDEX_KEY = "IndSnpIdxLdrBlock.snpIndex";
    public static final String IND_INDEX_KEY = "IndSnpIdxLdrBlock.indIndex";
    protected int depth = 1;
    protected IndexLoaderBlock snpLdr;
    protected IndexLoaderBlock indLdr;

    public IndSnpIdxLdrBlock() {
        this(false);
    }

    public IndSnpIdxLdrBlock(boolean legacy) {
        String snp_suf = "marker";
        String ind_suf = "indiv";
        if (legacy) {
            snp_suf = "snp";
            ind_suf = "sample";
        }
        this.snpLdr = new IndexLoaderBlock().setLabel("snps").setSuffix(snp_suf).setInputPropertyKey("IOProperties.IN_STEM").setOutputPropertyKey(SNP_INDEX_KEY);
        this.indLdr = new IndexLoaderBlock().setLabel("individuals").setSuffix(ind_suf).setInputPropertyKey("IOProperties.IN_STEM").setOutputPropertyKey(IND_INDEX_KEY);
    }

    public IndSnpIdxLdrBlock setDepth(int d) {
        this.depth = d;
        return this;
    }

    @Override
    public void commence() {
        this.snpLdr.setDepth(this.depth);
        this.indLdr.setDepth(this.depth);
        this.addProcessor(this.snpLdr);
        this.addProcessor(this.indLdr);
        super.commence();
    }

    public static class IdxPromoter
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            List sampleIdx = (List)c.get(IndSnpIdxLdrBlock.IND_INDEX_KEY);
            if (null == sampleIdx) {
                throw new RequiredPropertyValueNotFound(IndSnpIdxLdrBlock.IND_INDEX_KEY);
            }
            c.getSuperContract().put(IndSnpIdxLdrBlock.IND_INDEX_KEY, sampleIdx);
            List snpIdx = (List)c.get(IndSnpIdxLdrBlock.SNP_INDEX_KEY);
            if (null == snpIdx) {
                throw new RequiredPropertyValueNotFound(IndSnpIdxLdrBlock.SNP_INDEX_KEY);
            }
            c.getSuperContract().put(IndSnpIdxLdrBlock.SNP_INDEX_KEY, snpIdx);
            this.getProcessor().consume(c, bin, endOfInput);
        }
    }
}

