/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.Aggregator;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.contracts.ParallelMultiplexer;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.io.PathScanner;
import uk.ac.ox.well.t2d.async.metadata.FileLdrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.metadata.MetadataWriter;
import uk.ac.ox.well.t2d.async.parser.ColumnParser;
import uk.ac.ox.well.t2d.async.parser.rig.Bypass;
import uk.ac.ox.well.t2d.async.processors.CollectionSerializer;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class MultiSetLoader
extends SubSection {
    protected MetadataReader rdr = new MetadataReader();
    protected PathScanner scanner;
    protected MetadataWriter wtr;

    public MultiSetLoader() {
        this.rdr.setIsRequired(false);
        this.scanner = new PathScanner();
        this.scanner.addPattern("glob:**");
        this.wtr = new MetadataWriter();
        this.wtr.setDepth(1);
    }

    public MultiSetLoader setDirectoryInPropertyKey(String dirPropKey) {
        this.rdr.setPropertyKey(dirPropKey);
        return this;
    }

    public MultiSetLoader setOutPropertyKey(String propKey) {
        this.wtr.setPropertyKey(propKey);
        return this;
    }

    public PathScanner getScanner() {
        return this.scanner;
    }

    public MetadataReader getReader() {
        return this.rdr;
    }

    public MetadataWriter getWriter() {
        return this.wtr;
    }

    @Override
    public void commence() {
        Bypass.NullBypass bps = new Bypass.NullBypass();
        this.addProcessor(this.rdr);
        this.addProcessor(bps);
        this.addProcessor(this.scanner);
        this.addProcessor(new CollectionSerializer());
        this.addProcessor(new ParallelMultiplexer());
        FileLdrBlock.Character fndr = new FileLdrBlock.Character();
        fndr.getPathFinder().setDepth(1);
        this.addProcessor(fndr);
        ColumnParser cp = new ColumnParser();
        cp.setPayloadManager(new CollectionFactory.SetFactory().setReuse(false));
        this.addProcessor(cp);
        this.addProcessor(new CollectionAggregator());
        this.addProcessor(this.wtr);
        bps.setBypassProcessor(this.tail);
        super.commence();
    }

    public static class Rig
    extends ExecutionRig {
        MultiSetLoader blck = new MultiSetLoader();

        @Override
        public PrimaryContract execute() throws Exception {
            return this.execute(this.blck);
        }

        public MultiSetLoader getBlock() {
            return this.blck;
        }
    }

    public static class DirPropertyBypass
    extends Bypass.NullBypass {
        @Override
        public void logBypass(Contract c, Bucket bin, boolean endOfInput) {
            this.logger.info("No Subset Directory Property Set.");
        }
    }

    public class CollectionAggregator
    extends Aggregator<Map<Path, Collection>> {
        @Override
        protected Map<Path, Collection> newContext(Contract c) {
            return new HashMap<Path, Collection>();
        }

        @Override
        protected void aggregate(Map<Path, Collection> cxt, Contract subC, Object pi) {
            Object op;
            if (!(pi instanceof Collection)) {
                Formatter f = new Formatter();
                f.format("Expecting to find a Collection submitted to the ListAggregator, found: %s", pi.getClass());
                subC.fail(new Exception(f.toString()));
            }
            if (null == (op = subC.get("IOProperties.IN_PATH"))) {
                subC.fail(new Exception("Expecting to find an IN_PATH in the Contract, found null."));
            } else if (!(op instanceof Path)) {
                Formatter f = new Formatter();
                f.format("Expecting to find Path in the IN_PATH, found: %s", op.getClass());
                subC.fail(new Exception(f.toString()));
            }
            Path p = (Path)op;
            Collection list = (Collection)pi;
            cxt.put(p, list);
        }

        @Override
        public void finishPayload(Contract superC, Map<Path, Collection> map) {
            for (Map.Entry<Path, Collection> e : map.entrySet()) {
                MultiSetLoader.this.logger.info("Loaded subset from " + e.getKey().getFileName() + ", number of members: " + e.getValue().size());
            }
            MultiSetLoader.this.logger.info("Setting Loaded Subsets in Contract: " + superC);
        }
    }
}

