/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import java.nio.ByteBuffer;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.MultiplotHandler;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedParsingContext;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class MultiplotBedLoader
extends AbstractConveyor<Context, ByteBuffer, MultiplotHandler> {
    @Override
    protected Context newContext() {
        return new Context();
    }

    public class Context
    extends BedParsingContext<MultiplotHandler> {
        protected MultiplotHandler handler = new MultiplotHandler();

        @Override
        public void initialize() throws Exception {
            super.initialize();
            this.handler = new MultiplotHandler();
            this.handler.initialize(this.getContract());
        }

        @Override
        public void clear() {
            this.handler = null;
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<MultiplotHandler> po, boolean endOfContract) throws Exception {
            while (pi.hasRemaining()) {
                this.handleByte(pi.get());
            }
            if (endOfContract) {
                po.setPayload(this.handler);
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        @Override
        public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
            BimEntry bim = this.meta.getBimList().get(snpIndex);
            FamEntry fam = this.meta.getFamList().get(sampleIndex);
            this.handler.handleCall(fam, bim, call, (Object)null);
        }
    }
}

