/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.matrix.DuplicateLogic;
import uk.ac.ox.well.t2d.async.genotype.matrix.GenotypeMatrixSubset;
import uk.ac.ox.well.t2d.async.io.IOProperties;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedHandler;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;

public class MultiplotHandler
implements BedHandler {
    public static final Logger logger = LoggerFactory.getLogger(MultiplotHandler.class);
    public static final String PLOT_SEX = "MultiplotHandler.PlotBedSex";
    public static final String PLOT_CC = "MultiplotHandler.PlotBedCc";
    public static final String PLOT_SUBSETS = "MultiplotHandler.PlotSubsets";
    public static final String SUBSETS_DIR = "MultiplotHandler.SubsetsDir";
    protected List<BedMatrixFilter> filters = new ArrayList<BedMatrixFilter>();
    protected boolean plotSex;
    protected boolean plotCc;
    protected Map<Path, Set<String>> subsets;

    public List<BedMatrixFilter> getFilters() {
        return this.filters;
    }

    public void initialize(Contract c) throws RequiredPropertyValueNotFound {
        DuplicateLogic.Rule rule = DuplicateLogic.ruleValueOf(c, "DuplicateLogic.Rule");
        this.plotSex = false;
        String plotSexStr = (String)c.get(PLOT_SEX);
        if (null != plotSexStr) {
            this.plotSex = Boolean.parseBoolean(plotSexStr);
            logger.info("Generating separate gender plots? " + this.plotSex);
        }
        this.plotCc = false;
        String plotCcStr = (String)c.get(PLOT_CC);
        if (null != plotCcStr) {
            this.plotCc = Boolean.parseBoolean(plotCcStr);
            logger.info("Generating separate gender plots? " + this.plotCc);
        }
        this.subsets = (Map)c.get(PLOT_SUBSETS);
        if (null != this.subsets) {
            logger.info("Generating plots from sample subsets. Found " + this.subsets.size() + " subsets in total.");
        }
        logger.info("MplotHandler Contract: " + c);
        this.filters.clear();
        this.filters.add(new BedMatrixFilter("All"));
        if (this.plotSex) {
            this.filters.add(new SexFilter("Male", "1"));
            this.filters.add(new SexFilter("Female", "2"));
        }
        if (this.plotCc) {
            this.filters.add(new PhenotypeFilter("Controls", "1"));
            this.filters.add(new PhenotypeFilter("Cases", "2"));
        }
        if (null != this.subsets) {
            for (Map.Entry entry : this.subsets.entrySet()) {
                this.filters.add(new SubsetFilter((Path)entry.getKey(), (Set)entry.getValue()));
            }
        }
        for (BedMatrixFilter bedMatrixFilter : this.getFilters()) {
            if (null != rule) {
                bedMatrixFilter.getSubset().setDuplicateRule(rule);
            }
            bedMatrixFilter.initialize(c);
            logger.info("Initializing Filter: " + bedMatrixFilter.getLabel());
        }
    }

    public void handleCall(FamEntry fe, BimEntry be, BedConstants.Call cl, Object po) {
        for (BedMatrixFilter fltr : this.getFilters()) {
            fltr.handleCall(fe, be, cl, (Object)null);
        }
    }

    public Collection<GenotypeMatrixSubset> getResults() {
        ArrayList<GenotypeMatrixSubset> lst = new ArrayList<GenotypeMatrixSubset>();
        for (BedMatrixFilter fltr : this.getFilters()) {
            lst.add(fltr.getSubset());
        }
        return lst;
    }

    public static class SubsetFilter
    extends BedMatrixFilter {
        protected Set<String> sub;

        public SubsetFilter(Path path, Set<String> gd) {
            this.label = IOProperties.getLabelFromPath(path);
            this.sub = gd;
        }

        @Override
        public void handleCall(FamEntry fe, BimEntry be, BedConstants.Call cl, Object po) {
            if (this.sub.contains(fe.getIndividualId())) {
                super.handleCall(fe, be, cl, po);
            }
        }
    }

    public static class SexFilter
    extends BedMatrixFilter {
        String gender;

        public SexFilter(String lbl, String gd) {
            super(lbl);
            this.gender = gd;
        }

        @Override
        public void handleCall(FamEntry fe, BimEntry be, BedConstants.Call cl, Object po) {
            if (null != fe.getSex() && this.gender.equals(fe.getSex())) {
                super.handleCall(fe, be, cl, po);
            }
        }
    }

    public static class PhenotypeFilter
    extends BedMatrixFilter {
        String pheno;

        public PhenotypeFilter(String lbl, String pt) {
            super(lbl);
            this.pheno = pt;
        }

        @Override
        public void handleCall(FamEntry fe, BimEntry be, BedConstants.Call cl, Object po) {
            if (null != fe.getPhenotype() && this.pheno.equals(fe.getPhenotype())) {
                super.handleCall(fe, be, cl, po);
            }
        }
    }

    public static class BedMatrixFilter
    implements BedHandler {
        protected String label = null;
        protected GenotypeMatrixSubset subset = new GenotypeMatrixSubset();
        protected boolean isFirst = true;

        public BedMatrixFilter() {
        }

        public BedMatrixFilter(String lbl) {
            this();
            this.label = lbl;
        }

        public String getLabel() {
            return this.label;
        }

        public GenotypeMatrixSubset getSubset() {
            return this.subset;
        }

        public void initialize(Contract c) {
            this.subset.initialize(c);
        }

        public void handleCall(FamEntry fe, BimEntry be, BedConstants.Call cl, Object po) {
            if (this.isFirst) {
                if (this.subset.isIndMajor()) {
                    this.subset.getMetadata().put("MajorInfo", fe);
                } else {
                    this.subset.getMetadata().put("MajorInfo", be);
                }
                this.subset.getMetadata().put("FilterLabel", this.label);
                this.isFirst = false;
            }
            String[] alleles = be.toArray(cl);
            this.subset.handleCell(be.getSnpId(), fe.getIndividualId(), 0, alleles[0], null);
            this.subset.handleCell(be.getSnpId(), fe.getIndividualId(), 1, alleles[1], null);
        }
    }
}

