/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.ClusterPlotBedLoader;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.io.IOProperties;
import uk.ac.ox.well.t2d.async.metadata.MetadataWriter;
import uk.ac.ox.well.t2d.async.metadata.PropertyReporter;
import uk.ac.ox.well.t2d.async.parser.rig.Bypass;
import uk.ac.ox.well.t2d.async.ped.rig.BedDataLoader;

public class PedLdrBlock
extends SubSection {
    BedDataLoader bedLdr;
    ClusterPlotBedLoader clstrBedLdr;
    MetadataWriter metaWritr = new MetadataWriter();

    public PedLdrBlock() {
        this.setBypass(new PedLdrBypass());
        this.bedLdr = new BedDataLoader();
        this.clstrBedLdr = new ClusterPlotBedLoader();
        this.bedLdr.setProcessor(this.clstrBedLdr);
        this.metaWritr = new MetadataWriter();
        this.metaWritr.setPropertyKey("ClusterPlot.alleles");
        this.metaWritr.setDepth(1);
    }

    @Override
    public void setupSubContract(Contract c) {
        this.convertProperty(c, "allele_stem", "BimFamLoader.Stem");
    }

    @Override
    public void commence() {
        this.addProcessor(this.bedLdr);
        this.addProcessor(this.clstrBedLdr);
        this.addProcessor(this.metaWritr);
        PropertyReporter alleleRprtr = new PropertyReporter();
        alleleRprtr.setKey("ClusterPlot.alleles").setLabel("Allele Data").setIsRequired(false);
        this.addProcessor(alleleRprtr);
        super.commence();
    }

    public class PedLdrBypass
    extends Bypass {
        @Override
        protected boolean bypassRequired(Contract c, Bucket bin, boolean endOfInput) {
            Path baseDir;
            Path path;
            String stem = (String)c.get("allele_stem");
            if (null == stem) {
                return true;
            }
            String pathStr = stem;
            if (!stem.endsWith(".ped")) {
                pathStr = pathStr + ".ped";
            }
            if (Files.exists(path = IOProperties.toPath(baseDir = IOProperties.getBaseDir(c), pathStr), new LinkOption[0])) {
                this.logger.info("Found a PED files with allele_stem. Loading allele data from PED file.");
                return false;
            }
            this.logger.info("No PED file found using allele_stem.");
            return true;
        }
    }
}

