/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot;

import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.DataLdrBlock;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.genotype.matrix.GenotypeMatrixMdataLdrBlck;
import uk.ac.ox.well.t2d.async.metadata.PropertyReporter;
import uk.ac.ox.well.t2d.async.parser.rig.Bypass;

public class XyLdrBlock
extends GenotypeMatrixMdataLdrBlck {
    public static final String ALLELE_STEM = "allele_stem";
    protected DataLdrBlock xyLdr;
    protected AlleleLoader alleleLdr;

    public XyLdrBlock() {
        this(false);
    }

    public XyLdrBlock(boolean legacy) {
        super(legacy);
        String xy_suf = "xy";
        if (legacy) {
            xy_suf = "nor";
        }
        this.xyLdr = new DataLdrBlock(xy_suf, "ClusterPlot.XY");
        this.xyLdr.getMetadataWriter().setDepth(1);
        this.alleleLdr = new AlleleLoader();
        this.addProcessor(this.xyLdr);
        PropertyReporter xyRprtr = new PropertyReporter();
        xyRprtr.setKey("ClusterPlot.XY").setLabel("XY Data").setIsRequired(true);
        this.addProcessor(xyRprtr);
        this.addProcessor(this.alleleLdr);
        PropertyReporter allRprtr = new PropertyReporter();
        allRprtr.setKey("ClusterPlot.alleles").setLabel("Allele Data").setIsRequired(false);
    }

    public class AlleleLoaderBypass
    extends Bypass {
        @Override
        protected boolean bypassRequired(Contract c, Bucket bin, boolean endOfInput) {
            if (null == c.get(XyLdrBlock.ALLELE_STEM)) {
                this.logger.info("Did not find an Allele Stem set. Attempting to load Allele data using XY Stem.");
                return false;
            }
            this.logger.info("An Allele Stem has been set, therefore Alleles not being loaded from XY Stem.");
            return true;
        }
    }

    public class AlleleLoader
    extends SubSection {
        DataLdrBlock alleleLdr;

        public AlleleLoader() {
            this.bypass = new AlleleLoaderBypass();
            this.alleleLdr = new DataLdrBlock("allele", "ClusterPlot.alleles");
            this.alleleLdr.getMetadataWriter().setDepth(2);
        }

        @Override
        public void commence() {
            super.addProcessor(this.alleleLdr);
            super.commence();
        }
    }
}

