/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot.plot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.HardyWeinbergCalculation;
import uk.ac.ox.well.t2d.async.ped.BedConstants;

public abstract class ClusterPlot
implements Iterable<ClusterEntry> {
    public static final Logger logger = LoggerFactory.getLogger(ClusterPlot.class);
    public static final int MIN_PLOT_XY = 0;
    public static final int MAX_PLOT_XY = 2000;
    public static final String NUL_ID = "NUL";
    public static final String HET_ID = "HET";
    public static final String NC_ID = "NC";
    public static final String OUT_OF_BOUNDS = "OOB";
    public static final String HOM_1_ID = "HOM_1";
    public static final String HOM_2_ID = "HOM_2";
    private String id;
    private Map<String, Object> metadata = new LinkedHashMap<String, Object>();
    private BedConstants.Order order;
    private List<String> minorIdx;
    private String[] alleleData;
    private String[] xyData;
    boolean plotExcluded = false;
    List<ClusterPlotLegendEntry> legend;
    Map<String, String> info = new LinkedHashMap<String, String>();
    String allele1;
    String allele2;
    int allele1Count;
    int allele2Count;
    int callCount;
    int noCallCount;
    int exclCount;

    public void setId(String id) {
        this.id = id;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setOrder(BedConstants.Order order) {
        this.order = order;
    }

    public void setMinorIdx(List<String> minorIdx) {
        this.minorIdx = minorIdx;
    }

    public void setAlleleData(String[] alleleData) {
        this.alleleData = alleleData;
    }

    public void setXyData(String[] xyData) {
        this.xyData = xyData;
    }

    public void setPlotExcluded(boolean b) {
        this.plotExcluded = b;
    }

    public void initialize() {
        this.buildAlleleInfo();
        this.buildLegend();
        this.getInfo().put("Major Allele", this.getAllele1Label());
        this.getInfo().put("Minor Allele", this.getAllele2Label());
        this.getInfo().put("Number of Individuals", Integer.toString(this.getTotalCalls()));
        this.getInfo().put("Genotyping Rate", this.getGenotypeRate());
        this.getInfo().put("Minor Allele Frequency", this.getMinorAlleleFrequency());
        this.getInfo().put("Heterozygosity Rate", this.getHeterozygozityRate());
        this.getInfo().put("Hardy Weinberg", this.getHardyWeinbergPValue());
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public boolean isIndMajor() {
        return BedConstants.Order.IND_MAJOR.equals((Object)this.order);
    }

    public String getTypeLabel() {
        if (this.isIndMajor()) {
            return "sample";
        }
        return "snp";
    }

    public String getAllele1Label() {
        if (null != this.allele1) {
            return this.allele1;
        }
        return "N/A";
    }

    public String getAllele2Label() {
        if (null != this.allele2) {
            return this.allele2;
        }
        return "N/A";
    }

    public boolean getPlotExcluded() {
        return this.plotExcluded;
    }

    public List<ClusterPlotLegendEntry> getLegend() {
        return this.legend;
    }

    public int size() {
        return this.minorIdx.size();
    }

    public String toString() {
        return this.id + ":" + this.size();
    }

    @Override
    public Iterator<ClusterEntry> iterator() {
        return new ClusterEntryIterator();
    }

    public Iterator<ClusterEntry> getIterator() {
        return this.iterator();
    }

    public static float toFloat(String str) {
        return Float.parseFloat(str);
    }

    public abstract float scaleX(float var1);

    public abstract float scaleY(float var1);

    public String getAllele(String a1, String a2) {
        if (null == a1 || null == a2) {
            return NUL_ID;
        }
        if (this.isNoCallAllele(a1)) {
            return NC_ID;
        }
        if (!a1.equals(a2)) {
            return HET_ID;
        }
        if (this.isAllele1(a1)) {
            return HOM_1_ID;
        }
        return HOM_2_ID;
    }

    public boolean isMonomorph() {
        return 0 == this.allele2Count;
    }

    public boolean isAllele1(String allele) {
        return null != this.allele1 && this.allele1.equals(allele);
    }

    public boolean isTrueSnp(String a1, String a2) {
        return this.isSingleBaseAllele(a1) && this.isSingleBaseAllele(a2);
    }

    public boolean isSingleBaseAllele(String allele) {
        if (allele.length() != 1) {
            return false;
        }
        switch (allele.charAt(0)) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 't': {
                return true;
            }
        }
        return false;
    }

    public void buildAlleleInfo() {
        this.callCount = this.countCalls();
        this.noCallCount = this.countNoCalls();
        this.exclCount = this.countExcluded();
        this.initializeAlleles();
    }

    public void initializeAlleles() {
        Map<String, AtomicInteger> ac = this.countAlleles();
        if (ac.isEmpty()) {
            this.allele1 = null;
            this.allele1Count = 0;
            this.allele2 = null;
            this.allele2Count = 0;
        } else if (1 == ac.size()) {
            ac.put(null, new AtomicInteger());
            this.determineMinorMajorAllele(ac);
        } else if (2 == ac.size()) {
            this.determineMinorMajorAllele(ac);
        } else {
            throw new RuntimeException("Trouble when building alleles for clusterplot " + this.id + ". Found more than two alleles: " + ac);
        }
    }

    protected void determineMinorMajorAllele(Map<String, AtomicInteger> ac) {
        if (2 != ac.size()) {
            throw new RuntimeException("Expecting two here please!");
        }
        Iterator<Map.Entry<String, AtomicInteger>> it = ac.entrySet().iterator();
        Map.Entry<String, AtomicInteger> e1 = it.next();
        Map.Entry<String, AtomicInteger> e2 = it.next();
        if (e2.getValue().get() > e1.getValue().get()) {
            Map.Entry<String, AtomicInteger> te = e1;
            e1 = e2;
            e2 = te;
        }
        this.allele1 = e1.getKey();
        this.allele1Count = e1.getValue().get();
        this.allele2 = e2.getKey();
        this.allele2Count = e2.getValue().get();
    }

    protected Map<String, AtomicInteger> countAlleles() {
        HashMap<String, AtomicInteger> map = new HashMap<String, AtomicInteger>();
        for (int i = 0; i < this.alleleData.length; ++i) {
            String a1 = this.alleleData[i];
            if (null == a1 || this.isNoCallAllele(a1)) continue;
            AtomicInteger ai = (AtomicInteger)map.get(a1);
            if (null == ai) {
                ai = new AtomicInteger();
                map.put(a1, ai);
            }
            ai.incrementAndGet();
        }
        return map;
    }

    public String getHeterozygozityRate() {
        double tc = this.getTotalCalls();
        double hc = this.getCountByType(HET_ID);
        double val = 0.0;
        if (0.0 < tc) {
            val = hc / tc;
        }
        Formatter f = new Formatter();
        f.format("%.2f%%", val *= 100.0);
        return f.toString();
    }

    public String getHardyWeinbergPValue() {
        int maj;
        int het;
        int min = this.getCountByType(HOM_2_ID);
        int tot = min + (het = this.getCountByType(HET_ID)) + (maj = this.getCountByType(HOM_1_ID));
        if (tot == 0) {
            return "N/A";
        }
        double val = HardyWeinbergCalculation.hwCalculate(min, het, maj);
        Formatter f = new Formatter();
        f.format("%.3g", val);
        return f.toString();
    }

    public int getCountByType(String type) {
        for (ClusterPlotLegendEntry entry : this.legend) {
            if (!entry.getType().equals(type)) continue;
            return entry.getCount();
        }
        return 0;
    }

    public String getGenotypeRate() {
        double tc = this.getTotalCalls();
        double cc = this.callCount;
        double val = 0.0;
        if (0.0 < tc) {
            val = cc / tc;
        }
        Formatter f = new Formatter();
        f.format("%.2f%%", val *= 100.0);
        return f.toString();
    }

    public String getMinorAlleleFrequency() {
        double all = this.allele1Count + this.allele2Count;
        double min = this.allele2Count;
        double val = 0.0;
        if (0.0 < all) {
            val = min / all;
        }
        Formatter f = new Formatter();
        f.format("%.2f", val);
        return f.toString();
    }

    public int getTotalCalls() {
        return this.callCount + this.noCallCount;
    }

    protected int countNoCalls() {
        int count = 0;
        for (int i = 0; i < this.alleleData.length; ++i) {
            String a1 = this.alleleData[i];
            if (!this.isNoCallAllele(a1)) continue;
            ++count;
        }
        return count / 2;
    }

    protected int countCalls() {
        int count = 0;
        for (int i = 0; i < this.alleleData.length; ++i) {
            String a1 = this.alleleData[i];
            if (null == a1 || this.isNoCallAllele(a1)) continue;
            ++count;
        }
        return count / 2;
    }

    protected int countExcluded() {
        int count = 0;
        for (int i = 0; i < this.alleleData.length; ++i) {
            if (null != this.alleleData[i]) continue;
            ++count;
        }
        return count / 2;
    }

    protected boolean isNoCallAllele(String a1) {
        if (null == a1) {
            return false;
        }
        return "-".equals(a1) || "0".equals(a1);
    }

    protected void buildLegend() {
        HashMap<String, ClusterPlotLegendEntry> map = new HashMap<String, ClusterPlotLegendEntry>();
        for (ClusterEntry cpe : this) {
            if (NUL_ID.equals(cpe.getAllele()) && !this.getPlotExcluded()) continue;
            ClusterPlotLegendEntry cple = (ClusterPlotLegendEntry)map.get(cpe.getAllele());
            if (null == cple) {
                cple = new ClusterPlotLegendEntry(cpe.getAllele());
                map.put(cple.getType(), cple);
            }
            cple.inc();
        }
        this.legend = new ArrayList<ClusterPlotLegendEntry>();
        this.legend.addAll(map.values());
        Collections.sort(this.legend);
    }

    public class ClusterEntry {
        int idx = -1;
        String allele;
        String cssClass;
        String xlinkHref;
        float x;
        float y;

        public void next() {
            try {
                ++this.idx;
                this.allele = ClusterPlot.this.getAllele(this.getA1(), this.getA2());
                this.x = ClusterPlot.toFloat(this.getXy1());
                this.y = ClusterPlot.toFloat(this.getXy2());
                this.cssClass = this.allele;
                if ((ClusterPlot.HOM_1_ID.equals(this.allele) || ClusterPlot.HOM_2_ID.equals(this.allele)) && ClusterPlot.this.isSingleBaseAllele(this.getA1())) {
                    this.cssClass = this.getA1() + this.getA1();
                }
                this.xlinkHref = this.cssClass;
                this.x = ClusterPlot.this.scaleX(this.x);
                this.y = ClusterPlot.this.scaleY(this.y);
                this.applyMaxBounds();
                this.applyMinBounds();
            }
            catch (NullPointerException npe) {
                logger.error("NullPointerException from ClusterEntry: " + this.toString(), npe);
                throw npe;
            }
        }

        public void applyMaxBounds() {
            if (2000.0f < this.x || this.isNotReal(this.x)) {
                this.x = 2000.0f;
                this.xlinkHref = ClusterPlot.OUT_OF_BOUNDS;
            }
            if (2000.0f < this.y || this.isNotReal(this.y)) {
                this.y = 2000.0f;
                this.xlinkHref = ClusterPlot.OUT_OF_BOUNDS;
            }
        }

        public void applyMinBounds() {
            if (0.0f > this.x || this.isNotReal(this.x)) {
                this.x = 0.0f;
                this.xlinkHref = ClusterPlot.OUT_OF_BOUNDS;
            }
            if (0.0f > this.y || this.isNotReal(this.y)) {
                this.y = 0.0f;
                this.xlinkHref = ClusterPlot.OUT_OF_BOUNDS;
            }
        }

        public boolean isNotReal(float f) {
            return Float.isInfinite(f) | Float.isNaN(f);
        }

        public int getIndex() {
            return this.idx;
        }

        public String getId() {
            return (String)ClusterPlot.this.minorIdx.get(this.idx);
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public String getXlinkHref() {
            return this.xlinkHref;
        }

        public String getA1() {
            return ClusterPlot.this.alleleData[this.idx * 2];
        }

        public String getA2() {
            return ClusterPlot.this.alleleData[this.idx * 2 + 1];
        }

        public String getAllele() {
            return this.allele;
        }

        public String getXy1() {
            return ClusterPlot.this.xyData[this.idx * 2];
        }

        public String getXy2() {
            return ClusterPlot.this.xyData[this.idx * 2 + 1];
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("Index %d, Id %s, Alleles %s%s, X=%s, Y=%s", this.getIndex(), this.getId(), this.getA1(), this.getA2(), this.getXy1(), this.getXy2());
            return f.toString();
        }
    }

    public class ClusterEntryIterator
    implements Iterator<ClusterEntry> {
        ClusterEntry ce;

        public ClusterEntryIterator() {
            this.ce = new ClusterEntry();
        }

        @Override
        public boolean hasNext() {
            return this.ce.getIndex() + 1 < ClusterPlot.this.size();
        }

        @Override
        public ClusterEntry next() {
            this.ce.next();
            return this.ce;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public class ClusterPlotLegendEntry
    implements Comparable {
        private String type;
        private int count;

        public ClusterPlotLegendEntry(String t) {
            this.type = t;
            this.count = 0;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            switch (this.type) {
                case "HOM_1": {
                    if (!ClusterPlot.this.isSingleBaseAllele(ClusterPlot.this.allele1)) break;
                    return ClusterPlot.this.allele1 + ClusterPlot.this.allele1;
                }
                case "HOM_2": {
                    if (!ClusterPlot.this.isSingleBaseAllele(ClusterPlot.this.allele2)) break;
                    return ClusterPlot.this.allele2 + ClusterPlot.this.allele2;
                }
            }
            return this.type;
        }

        public String getAlleles() {
            switch (this.type) {
                case "HET": {
                    return ClusterPlot.this.allele1 + "/" + ClusterPlot.this.allele2;
                }
                case "HOM_1": {
                    return ClusterPlot.this.allele1 + "/" + ClusterPlot.this.allele1;
                }
                case "HOM_2": {
                    return ClusterPlot.this.allele2 + "/" + ClusterPlot.this.allele2;
                }
            }
            return null;
        }

        public void inc() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public String getLabel() {
            switch (this.type) {
                case "HET": {
                    return "Heterozyg [" + this.getAlleles() + "]";
                }
                case "NC": {
                    return "No Call";
                }
                case "NUL": {
                    return "Excluded";
                }
                case "HOM_1": {
                    return "Maj Homozyg [" + this.getAlleles() + "]";
                }
                case "HOM_2": {
                    return "Min Homozyg [" + this.getAlleles() + "]";
                }
            }
            return "";
        }

        public String toString() {
            return this.type + ":" + this.count;
        }

        public int compareTo(Object o) {
            ClusterPlotLegendEntry cple = (ClusterPlotLegendEntry)o;
            String thisAl = this.toOrderString();
            String thatAl = cple.toOrderString();
            return thisAl.compareTo(thatAl);
        }

        public String toOrderString() {
            switch (this.getType()) {
                case "HOM_1": {
                    return "00";
                }
                case "HET": {
                    return "01";
                }
                case "HOM_2": {
                    return "02";
                }
                case "NC": {
                    return "03";
                }
            }
            return "04";
        }
    }
}

