/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot.plot;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.plot.AffyClusterPlot;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.plot.ClusterPlot;

public class ClusterPlotFormatter {
    public static String HTML_PLOT_TEMPLATE = "uk/ac/ox/well/t2d/async/genotype/clusterplot/plot/ClusterPlotTemplateHtml.vm";
    public static String SVG_PLOT_TEMPLATE = "uk/ac/ox/well/t2d/async/genotype/clusterplot/plot/ClusterPlotTemplate.vm";
    protected Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    protected VelocityEngine ve = new VelocityEngine();
    protected Template svgTemplate;
    protected Template htmlTemplate;

    public ClusterPlotFormatter() {
        this.ve.setProperty("resource.loader", (Object)"classpath");
        this.ve.setProperty("classpath.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
        this.ve.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.ve.init();
        this.svgTemplate = this.loadTemplate(SVG_PLOT_TEMPLATE);
        this.htmlTemplate = this.loadTemplate(HTML_PLOT_TEMPLATE);
    }

    protected final Template loadTemplate(String location) {
        try {
            return this.ve.getTemplate(location);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new RuntimeException(rnfe);
        }
        catch (ParseErrorException pee) {
            throw new RuntimeException(pee);
        }
        catch (MethodInvocationException mie) {
            throw new RuntimeException(mie);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String format(ClusterPlot cp, boolean plotHtml) {
        VelocityContext context = new VelocityContext();
        if (cp instanceof AffyClusterPlot) {
            context.put("isAffy", (Object)true);
        }
        context.put("clstr", (Object)cp);
        StringWriter sw = new StringWriter();
        if (plotHtml) {
            this.htmlTemplate.merge((Context)context, (Writer)sw);
        } else {
            this.svgTemplate.merge((Context)context, (Writer)sw);
        }
        return sw.toString();
    }
}

