/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.clusterplot.plot;

import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.contracts.Token;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.MultiplotHandler;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.plot.AffyClusterPlot;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.plot.ClusterPlot;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.plot.IlluminaClusterPlot;
import uk.ac.ox.well.t2d.async.genotype.matrix.GenotypeMatrixSubset;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class ClusterPlotGenerator
extends AbstractConveyor<Context, Token, List> {
    public static final String ALLELE_DATA_KEY = "ClusterPlot.alleles";
    public static final String XY_DATA_KEY = "ClusterPlot.XY";
    public static final String PLOT_EXCLUDED_KEY = "ClusterPlot.PlotExcluded";
    public static final String SCALE_KEY = "ClusterPlot.Scale";

    public ClusterPlotGenerator() {
        CollectionFactory.ListFactory fac = new CollectionFactory.ListFactory();
        fac.setReuse(false);
        this.setPayloadManager(fac);
    }

    public static Scale parseScale(String value) {
        if (value.equalsIgnoreCase("Affymetrix") || value.equalsIgnoreCase("Affy")) {
            return Scale.AFFY;
        }
        return Scale.ILLUMINA;
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    public void plotSubsets(Scale scale, GenotypeMatrixSubset xy, Collection<GenotypeMatrixSubset> alleles, boolean plotExcluded, List po) {
        for (GenotypeMatrixSubset sst : alleles) {
            this.plotSubset(scale, xy, sst, plotExcluded, po);
        }
    }

    public void plotSubset(Scale scale, GenotypeMatrixSubset xy, GenotypeMatrixSubset allele, boolean plotExcluded, List po) {
        List<String> aidx = allele.getMinorList();
        List<String> xydx = xy.getMinorList();
        this.checkIndices(aidx, xydx);
        Map<String, String[]> alleleMap = allele.getMajorMap();
        Map<String, String[]> xyMap = xy.getMajorMap();
        for (Map.Entry<String, String[]> alleleEntry : alleleMap.entrySet()) {
            String[] xyValue = xyMap.get(alleleEntry.getKey());
            ClusterPlot plot = this.newClusterPlot(scale);
            plot.setId(alleleEntry.getKey());
            plot.setMetadata(allele.getMetadata());
            plot.setOrder(allele.getOrder());
            plot.setMinorIdx(aidx);
            plot.setAlleleData(alleleEntry.getValue());
            plot.setXyData(xyValue);
            plot.setPlotExcluded(plotExcluded);
            plot.initialize();
            po.add(plot);
        }
    }

    public ClusterPlot newClusterPlot(Scale scale) {
        if (Scale.AFFY.equals((Object)scale)) {
            return new AffyClusterPlot();
        }
        return new IlluminaClusterPlot();
    }

    public void checkIndices(List<String> aidx, List<String> xydx) throws RuntimeException {
        if (aidx.size() != xydx.size()) {
            Formatter f = new Formatter();
            f.format("Unable to proceed because minor index of alleles and minor index of xy data is different. Found %s minor entries for alleles, %s minor entries for xy", aidx.size(), xydx.size());
            String error = f.toString();
            throw new RuntimeException(error);
        }
        for (int i = 0; i < aidx.size(); ++i) {
            String xyid;
            String aid = aidx.get(i);
            if (aid.equals(xyid = xydx.get(i))) continue;
            Formatter f = new Formatter();
            f.format("Unable to proceed because minor index of alleles and minor index of xy data is different. At index %s, found minor entry '%s' for alleles, '%s' for xy", i, aid, xyid);
            String error = f.toString();
            throw new RuntimeException(error);
        }
    }

    public class Context
    extends ProcessingContext<Token, List> {
        @Override
        public ProcessingResult process(Token pi, List po, boolean endOfContract) {
            GenotypeMatrixSubset xy = (GenotypeMatrixSubset)this.getContract().get(ClusterPlotGenerator.XY_DATA_KEY);
            if (null == xy) {
                throw new RuntimeException("Did not find XY data");
            }
            Object allele = this.getContract().get(ClusterPlotGenerator.ALLELE_DATA_KEY);
            if (null == allele) {
                throw new RuntimeException("Did not find Allele data");
            }
            boolean plotExcluded = false;
            String plotExcludedStr = (String)this.getContract().get(ClusterPlotGenerator.PLOT_EXCLUDED_KEY);
            if (null != plotExcludedStr) {
                plotExcluded = Boolean.parseBoolean(plotExcludedStr);
                this.getLogger().info("Plot XY points with no allele data? " + plotExcluded);
            }
            Scale scale = Scale.ILLUMINA;
            String scaleStr = (String)this.getContract().get(ClusterPlotGenerator.SCALE_KEY);
            if (null != scaleStr) {
                scale = ClusterPlotGenerator.parseScale(scaleStr);
                this.getLogger().info("Specified scale mode: " + (Object)((Object)scale));
            }
            if (allele instanceof MultiplotHandler) {
                MultiplotHandler hndlr = (MultiplotHandler)allele;
                ClusterPlotGenerator.this.plotSubsets(scale, xy, hndlr.getResults(), plotExcluded, po);
            } else {
                GenotypeMatrixSubset mtrx = (GenotypeMatrixSubset)allele;
                ClusterPlotGenerator.this.plotSubset(scale, xy, mtrx, plotExcluded, po);
            }
            return ProcessingResult.BOTH_COMPLETE;
        }
    }

    public static enum Scale {
        ILLUMINA,
        AFFY;

    }
}

