/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.illumina;

import java.util.Map;
import uk.ac.ox.well.t2d.async.table.HeaderTableEntry;
import uk.ac.ox.well.t2d.lang.SequenceUtilities;

public class AnnotationEntry
implements HeaderTableEntry {
    private String name;
    private String strand;
    private String snp;
    private String chr;
    private String mapInfo;
    private String beadSetId;

    @Override
    public void set(long lineNumber, Map<String, String> recordData) throws Exception {
        this.name = recordData.get("Name");
        this.strand = recordData.get("IlmnStrand");
        this.snp = recordData.get("SNP");
        this.chr = recordData.get("Chr");
        this.mapInfo = recordData.get("MapInfo");
        this.beadSetId = recordData.get("BeadSetID");
    }

    @Override
    public void validate() throws Exception {
        if (null == this.name || null == this.strand || null == this.snp || null == this.chr || null == this.mapInfo || null == this.beadSetId) {
            throw new NullPointerException("One or more fields has not been set");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb, "\t");
        return sb.toString();
    }

    public StringBuilder toStringBuilder(String separator) {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb, separator);
        return sb;
    }

    public void toStringBuilder(StringBuilder sb, String separator) {
        sb.append(this.getName()).append(separator).append(this.getStrand()).append(separator).append(this.getSnp()).append(separator).append(this.getChr()).append(separator).append(this.getMapInfo()).append(separator).append(this.getBeadSetId()).append(separator).append(this.getAllele1()).append(separator).append(this.getAllele2());
    }

    public char getAllele1() {
        return this.toTop(this.getSnp().charAt(1));
    }

    public char getAllele2() {
        return this.toTop(this.getSnp().charAt(3));
    }

    protected char toTop(char c) {
        if ("BOT".equalsIgnoreCase(this.strand)) {
            return SequenceUtilities.flipChar(c);
        }
        return c;
    }

    public String getName() {
        return this.name;
    }

    public String getStrand() {
        return this.strand;
    }

    public String getSnp() {
        return this.snp;
    }

    public String getChr() {
        return this.chr;
    }

    public String getMapInfo() {
        return this.mapInfo;
    }

    public String getBeadSetId() {
        return this.beadSetId;
    }

    public static class Header
    extends AnnotationEntry {
        @Override
        public void toStringBuilder(StringBuilder sb, String separator) {
            sb.append("Name").append(separator).append("IlmnStrand").append(separator).append("SNP").append(separator).append("Chr").append(separator).append("MapInfo").append(separator).append("BeadSetID").append(separator).append("Allele1").append(separator).append("Allele2");
        }
    }
}

