/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.illumina;

import java.util.Collection;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.genotype.illumina.AnnotationEntry;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.table.HeaderTableEntry;
import uk.ac.ox.well.t2d.async.table.HeaderTableHandler;
import uk.ac.ox.well.t2d.async.table.HeaderTableLoader;
import uk.ac.ox.well.t2d.async.table.MapHandler;

public class AnnotationLoader
extends HeaderTableLoader {
    public static final String HEADING_SECTION = "[Heading]";
    public static final String ASSAY_SECTION = "[Assay]";
    public static final String CONTROLS_SECTION = "[Controls]";

    @Override
    protected HeaderTableEntry newEntry() {
        return new AnnotationEntry();
    }

    @Override
    protected TableParsingLogic newLogic() {
        CsvParsingLogic logic = new CsvParsingLogic();
        logic.setCellSeparator(',');
        return logic;
    }

    @Override
    protected TableCellHandler<Collection> newHandler() {
        return new AnnotationHandler(new HeaderTableLoader.HeaderTableEntryHandler(this));
    }

    public static class SimpleLoader
    extends AnnotationLoader {
        @Override
        protected TableCellHandler<Collection> newHandler() {
            return new HeaderTableHandler<Collection>(new HeaderTableLoader.HeaderTableEntryHandler(this));
        }
    }

    public class AnnotationHandler
    extends HeaderTableHandler {
        String section;
        boolean isSectionLine;

        public AnnotationHandler(MapHandler mh) {
            super(mh);
            this.section = null;
            this.isSectionLine = false;
        }

        @Override
        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket bo) throws Exception {
            if (this.isSectionLine) {
                if (meta.isEndOfLine()) {
                    this.isSectionLine = false;
                }
                return false;
            }
            if (1L == meta.getColumnNumber()) {
                switch (cellData.toString()) {
                    case "[Heading]": {
                        this.section = AnnotationLoader.HEADING_SECTION;
                        this.isSectionLine = true;
                        return false;
                    }
                    case "[Assay]": {
                        this.section = AnnotationLoader.ASSAY_SECTION;
                        this.isSectionLine = true;
                        return false;
                    }
                    case "[Controls]": {
                        this.section = AnnotationLoader.CONTROLS_SECTION;
                        this.isSectionLine = true;
                        return false;
                    }
                }
                return this.handleCell(meta, cellData, bo);
            }
            return this.handleCell(meta, cellData, bo);
        }

        protected boolean handleCell(TableCellMetadata meta, CharArraySequence cellData, Bucket bo) throws Exception {
            if (null == this.section) {
                return false;
            }
            switch (this.section) {
                case "[Heading]": {
                    return false;
                }
                case "[Assay]": {
                    return super.cell(meta, cellData, bo);
                }
                case "[Controls]": {
                    return false;
                }
            }
            return false;
        }
    }
}

