/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.illumina;

import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.genotype.illumina.AnnotationEntry;
import uk.ac.ox.well.t2d.async.genotype.illumina.AnnotationLoader;
import uk.ac.ox.well.t2d.async.genotype.illumina.AnnotationTransformerBlock;
import uk.ac.ox.well.t2d.async.gzip.GzipProperties;
import uk.ac.ox.well.t2d.async.io.IOProperties;
import uk.ac.ox.well.t2d.async.metadata.MdataLdrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.metadata.MetadataWriter;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.MapBuilder;
import uk.ac.ox.well.t2d.async.parser.rig.Bypass;

public class AnnotationMapLdrBlck
extends SubSection {
    public AnnotationMapLdrBlck() {
        this.addProcessor(new TrnsfrmrLdr());
        this.addProcessor(new ConciseLdr());
        MetadataReader rdr = new MetadataReader();
        rdr.setPropertyKey("illumina_annotation_list");
        rdr.setIsRequired(true);
        this.addProcessor(rdr);
        this.addProcessor(new AnnttnMapBldr());
        MetadataWriter wrtr = new MetadataWriter();
        wrtr.setPropertyKey("illumina_annotation_map");
        wrtr.setDepth(1);
        this.addProcessor(wrtr);
    }

    public static class AnnttnMapBldr
    extends MapBuilder {
        @Override
        public Object getKey(Object o) {
            AnnotationEntry ae = (AnnotationEntry)o;
            return ae.getName();
        }
    }

    public static class ConciseAnnotationBypass
    extends Bypass {
        @Override
        protected boolean bypassRequired(Contract c, Bucket bin, boolean endOfInput) {
            boolean b;
            String path = (String)c.get("concise_annotation_path");
            if (null == path) {
                throw new RequiredPropertyValueNotFound("concise_annotation_path");
            }
            boolean bl = b = IOProperties.pathExists(c, path) || GzipProperties.gzipPathExists(c, path);
            if (!b) {
                this.logger.info("No Concise Annotation File Found. Loading SNP information from Illumina Annotation file and generating Concise Version.");
            }
            return b;
        }
    }

    public static class AnnotationListBypass
    extends Bypass {
        @Override
        protected boolean bypassRequired(Contract c, Bucket bin, boolean endOfInput) {
            if (!c.containsKey("illumina_annotation_list")) {
                this.logger.info("Loading SNP information from Concise Annotation File.");
                return false;
            }
            return true;
        }
    }

    public static class ConciseLdr
    extends SubSection {
        public ConciseLdr() {
            this.setBypass(new AnnotationListBypass());
            MdataLdrBlock ldr = new MdataLdrBlock();
            ldr.setParser(new AnnotationLoader.SimpleLoader());
            ldr.setInputPropertyKey("concise_annotation_path");
            ldr.setOutputPropertyKey("illumina_annotation_list");
            ldr.getMetadataReader().setIsRequired(true);
            ldr.setDepth(1);
            this.addProcessor(ldr);
        }
    }

    public static class TrnsfrmrLdr
    extends SubSection {
        public TrnsfrmrLdr() {
            this.setBypass(new ConciseAnnotationBypass());
            this.addProcessor(new AnnotationTransformerBlock().setDepth(2));
        }
    }
}

