/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.illumina;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.table.IndexMapBuffer;

public class FinalReportHandler
extends IndexMapBuffer<StringBuilder[]> {
    protected boolean sampleMajor = true;
    protected String currentMajor = null;
    protected int majorCount = 0;
    protected int minorCount = 0;
    protected List<String> majorIndex = new ArrayList<String>();
    protected List<String> minorIndex = new ArrayList<String>();
    protected StringBuilder[] firstLineBuf = null;
    protected boolean isFirstLineBufFull = false;
    protected long currentLine = 0L;

    public FinalReportHandler setSampleMajor(boolean b) {
        this.sampleMajor = b;
        return this;
    }

    @Override
    public String[] getRequiredColumnHeaders() {
        return new String[]{"SNP Name", "Sample ID", "Allele1 - Top", "Allele2 - Top", "X", "Y", "X Raw", "Y Raw", "B Allele Freq", "Log R Ratio"};
    }

    @Override
    public boolean startTable(Bucket<StringBuilder[]> bo) throws Exception {
        this.firstLineBuf = this.newBuilderArray(this.getRequiredColumnHeaders().length);
        this.isFirstLineBufFull = false;
        return super.startTable(bo);
    }

    @Override
    public boolean endTable(Bucket<StringBuilder[]> bo) throws Exception {
        this.flushFirstLineBuffer(bo);
        this.validateMinorCount(this.currentLine);
        this.writeGenericData(bo.getPayload(), "\n");
        this.writeMajorIndex(bo);
        this.writeMinorIndex(bo);
        return false;
    }

    @Override
    public void clear() {
        this.currentMajor = null;
        this.majorCount = 0;
        this.minorCount = 0;
        this.majorIndex.clear();
        this.minorIndex.clear();
        this.clearBuilderArray(this.firstLineBuf);
        this.isFirstLineBufFull = false;
        this.currentLine = 0L;
    }

    @Override
    public boolean handleRecord(long recordNumber, StringBuilder[] recordData, Bucket<StringBuilder[]> bucketOut) throws Exception {
        StringBuilder min;
        StringBuilder maj;
        this.currentLine = recordNumber;
        if (this.sampleMajor) {
            maj = recordData[1];
            min = recordData[0];
        } else {
            maj = recordData[0];
            min = recordData[1];
        }
        return this.handleRecord(recordNumber, maj, min, recordData, bucketOut);
    }

    public void writeMajorIndex(Bucket<StringBuilder[]> bo) {
        if (this.sampleMajor) {
            this.writeIndexData(this.majorIndex, bo.getPayload()[0]);
        } else {
            this.writeIndexData(this.majorIndex, bo.getPayload()[1]);
        }
    }

    public void writeMinorIndex(Bucket<StringBuilder[]> bo) {
        if (this.sampleMajor) {
            this.writeIndexData(this.minorIndex, bo.getPayload()[1]);
        } else {
            this.writeIndexData(this.minorIndex, bo.getPayload()[0]);
        }
    }

    public void writeIndexData(List<String> lst, StringBuilder sb) {
        for (String str : lst) {
            sb.append(str).append("\n");
        }
    }

    public boolean handleRecord(long recordNumber, StringBuilder maj, StringBuilder min, StringBuilder[] recordData, Bucket<StringBuilder[]> bucketOut) {
        this.validateIds(recordNumber, recordData);
        this.flushFirstLineBuffer(bucketOut);
        boolean bufferFull = false;
        if (null == this.currentMajor) {
            this.currentMajor = maj.toString();
            this.minorIndex.add(min.toString());
            this.majorIndex.add(this.currentMajor);
            this.writeGenericData(bucketOut.getPayload(), this.currentMajor);
            this.writeDataColumn(recordData, bucketOut.getPayload());
        } else if (!this.currentMajor.contentEquals(maj)) {
            bufferFull = true;
            this.newMajorEntry(recordNumber, maj, min, recordData, bucketOut);
        } else {
            if (0 == this.majorCount) {
                this.minorIndex.add(min.toString());
            }
            this.writeDataColumn(recordData, bucketOut.getPayload());
        }
        this.validateMinorEntry(recordNumber, min);
        ++this.minorCount;
        return bufferFull;
    }

    public void newMajorEntry(long recordNumber, StringBuilder maj, StringBuilder min, StringBuilder[] recordData, Bucket<StringBuilder[]> bucketOut) {
        this.validateMinorCount(recordNumber);
        this.writeGenericData(bucketOut.getPayload(), "\n");
        this.currentMajor = maj.toString();
        this.majorIndex.add(this.currentMajor);
        ++this.majorCount;
        this.minorCount = 0;
        this.copyBuilderArray(recordData, this.firstLineBuf);
        this.isFirstLineBufFull = true;
    }

    public void flushFirstLineBuffer(Bucket<StringBuilder[]> bucketOut) {
        if (this.isFirstLineBufFull) {
            this.writeGenericData(bucketOut.getPayload(), this.currentMajor);
            this.writeDataColumn(this.firstLineBuf, bucketOut.getPayload());
            this.isFirstLineBufFull = false;
        }
    }

    public void writeGenericData(StringBuilder[] outArray, String data) {
        outArray[2].append(data);
        outArray[3].append(data);
        outArray[4].append(data);
        outArray[5].append(data);
    }

    public void writeDataColumn(StringBuilder[] recordData, StringBuilder[] outArray) {
        outArray[2].append("\t").append((CharSequence)recordData[2]).append(" ").append((CharSequence)recordData[3]);
        outArray[3].append("\t").append((CharSequence)recordData[4]).append(" ").append((CharSequence)recordData[5]);
        outArray[4].append("\t").append((CharSequence)recordData[6]).append(" ").append((CharSequence)recordData[7]);
        outArray[5].append("\t").append((CharSequence)recordData[8]).append(" ").append((CharSequence)recordData[9]);
    }

    protected void validateMinorCount(long recordNumber) {
        if (this.minorCount != this.minorIndex.size()) {
            Formatter f = new Formatter();
            f.format("Expecting %s minor entries per major entry; as determined by the first major entry in the report. Unexpectedly found a major entry with %s minor entries (major id %s, line number %s).", this.minorIndex.size(), this.minorCount, this.currentMajor, recordNumber);
            throw new IncompleteMajorEntryException(f.toString());
        }
    }

    protected void validateMinorEntry(long recordNumber, StringBuilder min) {
        String expectedMinor = this.minorIndex.get(this.minorCount);
        if (!expectedMinor.contentEquals(min)) {
            Formatter f = new Formatter();
            f.format("Expecting the minor entry %s at index %s; as determined by the first major entry in the report. Unexpectedly found a major entry with minor entry %s at index %s (major id %s, line number %s).", expectedMinor, this.minorCount, min, this.minorCount, this.currentMajor, recordNumber);
            throw new IncorrectMinorEntryException(f.toString());
        }
    }

    protected void validateIds(long recordNumber, StringBuilder[] recordData) {
        if (0 == recordData[0].length() || 0 == recordData[1].length()) {
            Formatter f = new Formatter();
            f.format("Expecting all lines to have a SNP and a sample id. Unexpectedly found a entry with missing id data: (sample id '%s', SNP id '%s', line number %s).", recordData[0], recordData[1], recordNumber);
            throw new RuntimeException(f.toString());
        }
    }

    public static class IncorrectMinorEntryException
    extends RuntimeException {
        IncorrectMinorEntryException(String msg) {
            super(msg);
        }
    }

    public static class IncompleteMajorEntryException
    extends RuntimeException {
        IncompleteMajorEntryException(String msg) {
            super(msg);
        }
    }
}

