/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.illumina;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.Demultiplexer;
import uk.ac.ox.well.t2d.async.genotype.affymetrix.tools.ArrayBranchBlck;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.genotype.illumina.FinalReportLoader;
import uk.ac.ox.well.t2d.async.genotype.illumina.StringBuilderArrayBranch;
import uk.ac.ox.well.t2d.async.metadata.FileLdrBlock;
import uk.ac.ox.well.t2d.async.metadata.FileWrtrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.metadata.PropertyInjector;
import uk.ac.ox.well.t2d.async.parser.rig.Bypass;
import uk.ac.ox.well.t2d.async.parser.rig.OutputPathBuilder;

public class FinalReportTransformerBlock
extends SubSection {
    public static final String FINAL_REPORT_IN_PATH_KEY = "FinalReport.IN_PATH";
    public static final String FINAL_REPORT_OUT_STEM_KEY = "FinalReport.OUT_STEM";

    public FinalReportTransformerBlock() {
        this.setBypass(new FinalReportBypass());
    }

    @Override
    public void setupSubContract(Contract c) {
        this.convertRequiredProperty(c, FINAL_REPORT_IN_PATH_KEY, "IOProperties.IN_PATH");
        this.convertRequiredProperty(c, FINAL_REPORT_OUT_STEM_KEY, "IOProperties.OUT_STEM");
    }

    @Override
    public void commence() {
        this.addProcessor(new MetadataReader().setIsRequired(true).setPropertyKey("IOProperties.IN_PATH"));
        this.addProcessor(new FileLdrBlock.Character());
        this.addProcessor(new FinalReportLoader());
        ArrayBranchBlck abb = new ArrayBranchBlck(new StringBuilderArrayBranch());
        abb.addBranch(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("indiv.gz"));
        abb.addBranch(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("marker.gz"));
        abb.addBranch(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("allele.gz"));
        abb.addBranch(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("xy.gz"));
        abb.addBranch(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("raw_xy.gz"));
        abb.addBranch(new PropertyInjector().setKey("IOProperties.OUT_SUFFIX").setValue("logr.gz"));
        this.addProcessor(abb);
        this.addProcessor(new OutputPathBuilder());
        this.addProcessor(new FileWrtrBlock.CharWrtr());
        this.addProcessor(new Demultiplexer());
        super.commence();
    }

    public static Set<Path> getOutputPaths(String stem) {
        LinkedHashSet<Path> lhe = new LinkedHashSet<Path>();
        lhe.add(Paths.get(stem + "." + "indiv" + ".gz", new String[0]));
        lhe.add(Paths.get(stem + "." + "marker" + ".gz", new String[0]));
        lhe.add(Paths.get(stem + "." + "allele" + ".gz", new String[0]));
        lhe.add(Paths.get(stem + "." + "xy" + ".gz", new String[0]));
        lhe.add(Paths.get(stem + "." + "raw_xy" + ".gz", new String[0]));
        lhe.add(Paths.get(stem + "." + "logr" + ".gz", new String[0]));
        return lhe;
    }

    public static class FinalReportBypass
    extends Bypass {
        @Override
        protected boolean bypassRequired(Contract c, Bucket bin, boolean endOfInput) {
            if (!c.containsKey(FinalReportTransformerBlock.FINAL_REPORT_IN_PATH_KEY)) {
                this.logger.info("FinalReport.IN_PATH property not found. Bypassing FinalReport transformation.");
                return true;
            }
            if (!c.containsKey(FinalReportTransformerBlock.FINAL_REPORT_OUT_STEM_KEY)) {
                this.logger.info("FinalReport.OUT_STEM property not found. Bypassing FinalReport transformation.");
                return true;
            }
            String inPath = (String)c.get(FinalReportTransformerBlock.FINAL_REPORT_IN_PATH_KEY);
            String outStem = (String)c.get(FinalReportTransformerBlock.FINAL_REPORT_OUT_STEM_KEY);
            Path ip = Paths.get(inPath, new String[0]);
            if (!Files.exists(ip, new LinkOption[0])) {
                this.logger.warn("Property FinalReport.OUT_STEM was specified, but could not locate specified FinalReport file: " + inPath + ". Bypassing FinalReport transformation.");
                return true;
            }
            if (Files.isDirectory(ip, new LinkOption[0])) {
                this.logger.warn("Property FinalReport.OUT_STEM was specified, but unexpectedly specified a direcory not a regular file. Bypassing FinalReport transformation.");
                return true;
            }
            Set<Path> ops = FinalReportTransformerBlock.getOutputPaths(outStem);
            LinkedHashSet<Path> found = new LinkedHashSet<Path>();
            for (Path op : ops) {
                if (!Files.exists(op, new LinkOption[0])) continue;
                found.add(op);
            }
            if (!found.isEmpty()) {
                this.logger.info("Found existing FinalReport output file(s) " + found + ". Bypassing FinalReport transformation.");
                return true;
            }
            return false;
        }
    }
}

