/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.matrix;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.taqman.rig.Uniquerizer;

public class DuplicateLogic {
    public static final Logger LOGGER = LoggerFactory.getLogger(DuplicateLogic.class);
    public static final String DUPLICATE_RULE_KEY = "DuplicateLogic.Rule";
    protected Rule rule = Rule.REMOVE_ALL;

    public DuplicateLogic setRule(Rule r) {
        this.rule = r;
        return this;
    }

    public List<String> apply(String label, List<String> idx) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        HashSet<String> dups = new HashSet<String>();
        int dupCount = 0;
        for (int iidx = 0; iidx < idx.size(); ++iidx) {
            String str = idx.get(iidx);
            if (set.contains(str)) {
                dups.add(str);
                ++dupCount;
                continue;
            }
            set.add(str);
        }
        List<String> result = !dups.isEmpty() ? this.handleDuplicates(label, idx, set, dups, dupCount) : idx;
        Formatter f = new Formatter();
        f.format("Applying Duplicate Rule \"%s\" to %d %s entries, %d entries retained", new Object[]{this.rule, idx.size(), label, result.size()});
        LOGGER.debug(f.toString());
        return result;
    }

    public List<String> handleDuplicates(String label, List<String> idx, LinkedHashSet<String> set, HashSet<String> dups, int dupCount) {
        switch (this.rule) {
            case KEEP_FIRST: {
                return this.keepFirst(label, set, dups, dupCount);
            }
        }
        return this.removeAll(label, set, dups, dupCount);
    }

    public List<String> keepFirst(String label, LinkedHashSet<String> set, HashSet<String> dups, int dupCount) {
        Formatter f = new Formatter();
        f.format("Found %d duplicate %s ids while building index. The first entry using a duplicate id will be retained - this may cause unexpected problems. %d subsequent %s entries with the following ids will be excluded: %s", dups.size(), label, dupCount, label, dups);
        LOGGER.warn(f.toString());
        ArrayList<String> lst = new ArrayList<String>();
        lst.addAll(set);
        return lst;
    }

    public List<String> removeAll(String label, LinkedHashSet<String> set, HashSet<String> dups, int dupCount) {
        Formatter f = new Formatter();
        f.format("Found %d duplicate %s ids while building index. All entries sharing a duplicate id will be removed. All %d %s entries with the following ids will be excluded: %s", dups.size(), label, dupCount, label, dups);
        LOGGER.warn(f.toString());
        set.removeAll(dups);
        ArrayList<String> lst = new ArrayList<String>();
        lst.addAll(set);
        return lst;
    }

    public List<String> keepAll(String label, List<String> idx, HashSet<String> dups, int dupCount) {
        Formatter f = new Formatter();
        f.format("Found %d duplicate %s ids while building index. All entries sharing a duplicate id will be retained - this may cause unexpected problems. Found %d duplicate %s entries in total: %s", dups.size(), label, dupCount, label, dups);
        LOGGER.warn(f.toString());
        return idx;
    }

    public List<String> renameAll(String label, List<String> idx, HashSet<String> dups, int dupCount) {
        Formatter f = new Formatter();
        f.format("Found %d duplicate %s ids while building index. All subsequent duplicate ids will be amended. %d duplicate %s entries will be renamed: %s", dups.size(), label, dupCount, label, dups);
        LOGGER.warn(f.toString());
        Uniquerizer uniqzr = new Uniquerizer();
        return uniqzr.uniquerizeAll(idx);
    }

    public static Rule ruleValueOf(Contract c, String key) {
        Object value = c.get(key);
        if (null == value) {
            return null;
        }
        try {
            return Rule.valueOf(value.toString());
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static enum Rule {
        KEEP_FIRST,
        REMOVE_ALL;

    }
}

