/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.matrix;

import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.GenotypeProperties;
import uk.ac.ox.well.t2d.async.genotype.matrix.DuplicateLogic;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.ped.BedConstants;

public abstract class GenotypeMatrixHandler<PO>
extends TableCellHandlerBase<PO> {
    public Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    public static final String ROW_OFFSET_KEY = "GenotypeTableHandler.RowOffset";
    public static final String COLUMN_OFFSET_KEY = "GenotypeTableHandler.ColumnOffset";
    protected BedConstants.Order inputOrder = BedConstants.Order.IND_MAJOR;
    protected int subfieldCount = 2;
    protected int rowOffset;
    protected int columnOffset;
    protected List<String> sampleIdx;
    protected List<String> snpIdx;
    protected int minorEntryCount;
    protected DuplicateLogic.Rule duplicateRule = DuplicateLogic.Rule.REMOVE_ALL;

    @Override
    public void clear() {
        super.clear();
        this.columnOffset = 0;
        this.rowOffset = 0;
        this.sampleIdx = null;
        this.snpIdx = null;
        this.minorEntryCount = 0;
    }

    public BedConstants.Order getInputOrder() {
        return this.inputOrder;
    }

    public GenotypeMatrixHandler setDuplicateRule(DuplicateLogic.Rule rule) {
        this.duplicateRule = rule;
        return this;
    }

    @Override
    public boolean startTable(Bucket<PO> bo) throws Exception {
        this.initialize(this.getContract());
        return super.startTable(bo);
    }

    public void initialize(Contract c) {
        Object rowOff;
        Object colOff;
        BedConstants.Order ord;
        DuplicateLogic.Rule rule = DuplicateLogic.ruleValueOf(c, "DuplicateLogic.Rule");
        if (null != rule) {
            this.setDuplicateRule(rule);
        }
        if (null != (ord = GenotypeProperties.orderValueOf(c, "gt_input_order"))) {
            this.inputOrder = ord;
        }
        if (null != (colOff = c.get(COLUMN_OFFSET_KEY))) {
            this.columnOffset = Integer.parseInt(colOff.toString());
        }
        if (null != (rowOff = c.get(ROW_OFFSET_KEY))) {
            this.rowOffset = Integer.parseInt(rowOff.toString());
        }
        if (0 != this.rowOffset || 0 != this.columnOffset) {
            String msg = String.format("Parsing Genotype Table with row offset %d & column offset %d", this.rowOffset, this.columnOffset);
            this.LOGGER.info(msg);
        }
        this.sampleIdx = (List)c.get("IndSnpIdxLdrBlock.indIndex");
        if (null == this.sampleIdx) {
            throw new RequiredPropertyValueNotFound("IndSnpIdxLdrBlock.indIndex");
        }
        this.snpIdx = (List)c.get("IndSnpIdxLdrBlock.snpIndex");
        if (null == this.snpIdx) {
            throw new RequiredPropertyValueNotFound("IndSnpIdxLdrBlock.snpIndex");
        }
        this.minorEntryCount = BedConstants.Order.IND_MAJOR.equals((Object)this.inputOrder) ? this.snpIdx.size() : this.sampleIdx.size();
    }

    @Override
    public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket<PO> bo) throws Exception {
        int majIdx = (int)meta.getLineNumber() - 1;
        int colIdx = (int)meta.getColumnNumber() - 1;
        if (0 <= (majIdx -= this.rowOffset) && 0 <= (colIdx -= this.columnOffset)) {
            int minIdx = colIdx / this.subfieldCount;
            int subfieldPosition = colIdx % this.subfieldCount;
            return this.cell(majIdx, minIdx, subfieldPosition, cellData, bo);
        }
        return false;
    }

    public boolean cell(int majIdx, int minIdx, int pos, CharArraySequence cellData, Bucket<PO> bo) {
        try {
            if (BedConstants.Order.IND_MAJOR.equals((Object)this.inputOrder)) {
                String snp = this.snpIdx.get(minIdx);
                String sample = this.sampleIdx.get(majIdx);
                return this.handleCell(snp, sample, pos, cellData, bo);
            }
            String snp = this.snpIdx.get(majIdx);
            String sample = this.sampleIdx.get(minIdx);
            return this.handleCell(snp, sample, pos, cellData, bo);
        }
        catch (IndexOutOfBoundsException iobe) {
            String msg = new Formatter().format("Found a cell beyond the SNP/SAMPLE bounds. Major:%s, Minor:%s, Pos:%s, Cell:%s", majIdx, minIdx, pos, cellData).toString();
            throw new RuntimeException(msg, iobe);
        }
    }

    public boolean handleCell(String snp, String ind, int position, CharArraySequence cellData, Bucket<PO> bucketOut) {
        return false;
    }
}

