/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.matrix;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.matrix.DuplicateLogic;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.ped.BedConstants;

public class GenotypeMatrixIndex {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenotypeMatrixIndex.class.getName());
    public static final String GT_MATRIX_INDEX = "GenotypeMatrixIndex.GT_MATRIX_INDEX";
    protected Map<String, Object> metadata = new HashMap<String, Object>();
    DuplicateLogic dupLogic = new DuplicateLogic();
    protected int subfieldCount = 2;
    BedConstants.Order order = BedConstants.Order.SNP_MAJOR;
    List<String> majorList;
    LinkedHashSet<String> majorSet;
    List<String> minorList;
    LinkedHashSet<String> minorSet;

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public GenotypeMatrixIndex setDuplicateRule(DuplicateLogic.Rule rule) {
        this.dupLogic.setRule(rule);
        return this;
    }

    public GenotypeMatrixIndex setOrder(BedConstants.Order order) {
        this.order = order;
        return this;
    }

    public void initialize(Contract c) throws RequiredPropertyValueNotFound {
        List sampleIdx = (List)c.get("IndSnpIdxLdrBlock.indIndex");
        if (null == sampleIdx) {
            throw new RequiredPropertyValueNotFound("IndSnpIdxLdrBlock.indIndex");
        }
        List snpIdx = (List)c.get("IndSnpIdxLdrBlock.snpIndex");
        if (null == snpIdx) {
            throw new RequiredPropertyValueNotFound("IndSnpIdxLdrBlock.snpIndex");
        }
        Set includedSamples = (Set)c.get("FilterLdrBlock.indExclusionSet");
        Set includedSnps = (Set)c.get("FilterLdrBlock.snpInclusionSet");
        if (BedConstants.Order.IND_MAJOR.equals((Object)this.order)) {
            this.buildMinor(snpIdx, includedSnps);
            this.buildMajor(sampleIdx, includedSamples);
        } else {
            this.buildMinor(sampleIdx, includedSamples);
            this.buildMajor(snpIdx, includedSnps);
        }
    }

    public List<String> getMinorList() {
        return this.minorList;
    }

    public List<String> getMajorList() {
        return this.majorList;
    }

    public LinkedHashSet<String> getMinorSet() {
        return this.minorSet;
    }

    public LinkedHashSet<String> getMajorSet() {
        return this.majorSet;
    }

    public BedConstants.Order getOrder() {
        return this.order;
    }

    public boolean isSnpMajor() {
        return BedConstants.Order.SNP_MAJOR.equals((Object)this.order);
    }

    public boolean isIndMajor() {
        return BedConstants.Order.IND_MAJOR.equals((Object)this.order);
    }

    public List<String> getSnpList() {
        if (this.isSnpMajor()) {
            return this.getMajorList();
        }
        return this.getMinorList();
    }

    public List<String> getIndList() {
        if (this.isIndMajor()) {
            return this.getMajorList();
        }
        return this.getMinorList();
    }

    public boolean containsMajorMinor(String maj, String min) {
        return this.majorSet.contains(maj) && this.minorSet.contains(min);
    }

    public boolean containsMajor(String maj) {
        return this.majorSet.contains(maj);
    }

    public boolean containsMinor(String min) {
        return this.minorSet.contains(min);
    }

    public boolean contains(String snp, String ind) {
        if (this.isIndMajor()) {
            return this.containsMajorMinor(ind, snp);
        }
        return this.containsMajorMinor(snp, ind);
    }

    public void buildMinor(List<String> idx, Set<String> included) {
        this.minorList = this.prepareIndex("minor", idx, included);
        this.minorSet = new LinkedHashSet();
        this.minorSet.addAll(this.minorList);
    }

    public void buildMajor(List<String> idx, Set<String> included) {
        this.majorList = this.prepareIndex("major", idx, included);
        this.majorSet = new LinkedHashSet();
        this.majorSet.addAll(this.majorList);
    }

    public List<String> prepareIndex(String label, List<String> idx, Set<String> included) {
        List<String> subList;
        List<String> dupIdx = this.dupLogic.apply(label, idx);
        if (null != included) {
            subList = new ArrayList<String>();
            for (int iidx = 0; iidx < dupIdx.size(); ++iidx) {
                String str = dupIdx.get(iidx);
                if (!included.contains(str)) continue;
                subList.add(str);
            }
        } else {
            subList = dupIdx;
        }
        if (null != included) {
            Formatter f = new Formatter();
            f.format("Applying inclusion set of %d to %d %s entries, %d entries retained", included.size(), dupIdx.size(), label, subList.size());
            LOGGER.info(f.toString());
        }
        return subList;
    }
}

