/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.matrix;

import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.genotype.matrix.GenotypeMatrixIndex;
import uk.ac.ox.well.t2d.async.ped.BedConstants;

public class GenotypeMatrixSubset
extends GenotypeMatrixIndex {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenotypeMatrixSubset.class.getName());
    Map<String, String[]> major = new HashMap<String, String[]>();
    Map<String, Integer> minor = new HashMap<String, Integer>();

    public Map<String, String[]> getMajorMap() {
        return this.major;
    }

    public Map<String, Integer> getMinorMap() {
        return this.minor;
    }

    public void handleCell(String snp, String ind, int pos, CharSequence cellData, Bucket bo) {
        if (BedConstants.Order.IND_MAJOR.equals((Object)this.order)) {
            this.handleMajorMinor(ind, snp, pos, cellData);
        } else {
            this.handleMajorMinor(snp, ind, pos, cellData);
        }
    }

    public void handleMajorMinor(String maj, String min, int pos, CharSequence cellData) {
        Integer i;
        String[] arry = this.major.get(maj);
        if (null != arry && null != (i = this.minor.get(min))) {
            try {
                arry[i.intValue() * this.subfieldCount + pos] = cellData.toString();
            }
            catch (IndexOutOfBoundsException ioobe) {
                Formatter f = new Formatter();
                f.format("Error while handling gt data: MAJ=%s, MIN=%s, POS=%s, CELL=%s, I=%s", maj, min, pos, cellData, i);
                LOGGER.error(f.toString());
                LOGGER.error(this.toString());
                throw ioobe;
            }
        }
    }

    @Override
    public void buildMinor(List<String> idx, Set<String> included) {
        super.buildMinor(idx, included);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int iidx = 0; iidx < this.minorList.size(); ++iidx) {
            String str = (String)this.minorList.get(iidx);
            map.put(str, iidx);
        }
        this.minor = map;
    }

    @Override
    public void buildMajor(List<String> idx, Set<String> included) {
        super.buildMajor(idx, included);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String str : this.majorList) {
            String[] strs = new String[this.minorList.size() * this.subfieldCount];
            map.put(str, strs);
        }
        this.major = map;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("GenotypeMatrixSubset: SubfieldCount=%s, Order=%s, MajorSize=%s, MinorSize=%s", new Object[]{this.subfieldCount, this.order, this.major.size(), this.minor.size()});
        return f.toString();
    }
}

