/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.matrix;

import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.processors.BucketBase;

public class MatrixProperties {
    public static String getMatrixOutPath(Contract c) {
        String stem = (String)c.get("IOProperties.OUT_STEM");
        if (null == stem || stem.isEmpty()) {
            throw new RequiredPropertyValueNotFound("IOProperties.OUT_STEM");
        }
        String matrixType = MatrixProperties.getMatrixTypeComponent(c);
        String sep = ".";
        StringBuilder path = new StringBuilder();
        path.append(stem).append(sep).append(matrixType);
        String sfx = (String)c.get("IOProperties.OUT_SUFFIX");
        if (null != sfx && !sfx.isEmpty()) {
            path.append(sep).append(sfx);
        }
        return path.toString();
    }

    public static String getMatrixInPath(Contract c) {
        String stem = (String)c.get("IOProperties.IN_STEM");
        if (null == stem || stem.isEmpty()) {
            throw new RequiredPropertyValueNotFound("IOProperties.IN_STEM");
        }
        String matrixType = MatrixProperties.getMatrixTypeComponent(c);
        String sep = ".";
        StringBuilder path = new StringBuilder();
        path.append(stem).append(sep).append(matrixType);
        String sfx = (String)c.get("IOProperties.IN_SUFFIX");
        if (null != sfx && !sfx.isEmpty()) {
            path.append(sep).append(sfx);
        }
        return path.toString();
    }

    public static String getMatrixTypeComponent(Contract c) {
        String matrix_type = (String)c.get("GenotypeProperties.MatrixTypeComponent");
        if (null == matrix_type || matrix_type.isEmpty()) {
            throw new RequiredPropertyValueNotFound("GenotypeProperties.MatrixTypeComponent");
        }
        return matrix_type;
    }

    public static class OutputPathInitiator
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            String outPath = MatrixProperties.getMatrixOutPath(c);
            this.logger.info("Writing " + this.getLabel() + " to Output Path: " + outPath);
            c.put("IOProperties.OUT_PATH", outPath);
            this.getProcessor().consume(c, bin, endOfInput);
        }

        @Override
        public String getLabel() {
            if (null == this.label) {
                return "data";
            }
            return this.label;
        }
    }

    public static class InputPathInitiator
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            String inPath = MatrixProperties.getMatrixInPath(c);
            this.logger.info("Reading " + this.getLabel() + " from Input Path: " + inPath);
            BucketBase<String> bb = new BucketBase<String>();
            bb.setPayload(inPath);
            this.getProcessor().consume(c, bb, endOfInput);
        }

        @Override
        public String getLabel() {
            if (null == this.label) {
                return "data";
            }
            return this.label;
        }
    }
}

