/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.matrix.format;

import java.nio.CharBuffer;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.genotype.matrix.GenotypeMatrixIndex;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;

public class GenotypeMatrixFormatterIndex
extends GenotypeMatrixIndex {
    protected int charMaxGuide = 500000;
    protected StringBuilder sb;
    protected int colCount;

    public GenotypeMatrixFormatterIndex setCharMaxGuide(int i) {
        this.charMaxGuide = i;
        return this;
    }

    @Override
    public void initialize(Contract c) throws RequiredPropertyValueNotFound {
        super.initialize(c);
        this.sb = new StringBuilder(this.charMaxGuide);
        this.colCount = 0;
    }

    public boolean cell(String snp, String ind, int pos, CharArraySequence cellData, Bucket<CharBuffer> bo) {
        if (this.contains(snp, ind)) {
            if (0 == this.sb.length()) {
                if (this.isIndMajor()) {
                    this.sb.append(ind);
                } else {
                    this.sb.append(snp);
                }
            }
            if (pos >= this.subfieldCount - 1) {
                ++this.colCount;
                if (this.colCount >= this.getMinorList().size()) {
                    this.sb.append("\n");
                    this.colCount = 0;
                    if (this.sb.length() >= this.charMaxGuide) {
                        CharBuffer cb = this.toCharBuffer();
                        bo.setPayload(cb);
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public CharBuffer toCharBuffer() {
        CharBuffer cb = CharBuffer.wrap(this.sb.toString());
        this.sb.setLength(0);
        return cb;
    }
}

