/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.zcall;

import java.nio.CharBuffer;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.ped.WhiteSpaceParsingLogic;
import uk.ac.ox.well.t2d.async.processors.NullPayloadManager;

public class ZcallMatrixTransformer
extends TableParser<CharBuffer> {
    public static final String SAMPLE_INCLUSION_SET = "ZcallMatrixTransformer.SAMPLE_INCLUSION_SET";
    protected int charMaxGuide = 500000;

    public ZcallMatrixTransformer() {
        this.setPayloadManager(new NullPayloadManager());
    }

    public ZcallMatrixTransformer setCharMaxGuide(int i) {
        this.charMaxGuide = i;
        return this;
    }

    @Override
    protected TableParsingLogic newLogic() {
        return new WhiteSpaceParsingLogic();
    }

    @Override
    protected TableCellHandler<CharBuffer> newHandler() {
        return new CallHandler();
    }

    public class CallHandler
    extends TableCellHandlerBase<CharBuffer> {
        StringBuilder sb;
        Set<String> sampleInclusions;
        Set<Long> columnInclusions;

        public CallHandler() {
            this.sb = new StringBuilder(ZcallMatrixTransformer.this.charMaxGuide);
        }

        @Override
        public boolean startTable(Bucket<CharBuffer> bo) throws Exception {
            this.sampleInclusions = (Set)this.getContractMetadata(ZcallMatrixTransformer.SAMPLE_INCLUSION_SET);
            if (null == this.sampleInclusions) {
                throw new RequiredPropertyValueNotFound(ZcallMatrixTransformer.SAMPLE_INCLUSION_SET);
            }
            this.columnInclusions = new HashSet<Long>();
            return false;
        }

        @Override
        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket<CharBuffer> bo) throws Exception {
            if (meta.getLineNumber() == 1L) {
                if (3L >= meta.getColumnNumber()) {
                    this.columnInclusions.add(meta.getColumnNumber());
                    if (1L != meta.getColumnNumber()) {
                        this.sb.append("\t");
                    }
                    this.sb.append(cellData);
                } else {
                    String[] split = cellData.toString().split("\\.");
                    if (this.sampleInclusions.contains(split[0])) {
                        this.columnInclusions.add(meta.getColumnNumber());
                        this.sb.append("\t");
                        this.sb.append(cellData);
                    }
                }
                if (meta.isEndOfLine()) {
                    this.sb.append("\n");
                }
                return false;
            }
            if (this.columnInclusions.contains(meta.getColumnNumber())) {
                if (1L != meta.getColumnNumber()) {
                    this.sb.append("\t");
                }
                this.sb.append(cellData);
            }
            if (meta.isEndOfLine()) {
                this.sb.append("\n");
                if (this.sb.length() >= ZcallMatrixTransformer.this.charMaxGuide) {
                    CharBuffer cb = this.toCharBuffer();
                    bo.setPayload(cb);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean endTable(Bucket<CharBuffer> bo) throws Exception {
            CharBuffer cb = this.toCharBuffer();
            bo.setPayload(cb);
            return false;
        }

        public CharBuffer toCharBuffer() {
            CharBuffer cb = CharBuffer.wrap(this.sb.toString());
            this.sb.setLength(0);
            return cb;
        }
    }
}

