/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip;

import java.util.Arrays;

public class ByteArrayWindow {
    protected byte[] array;
    protected int count;
    protected int size;

    public ByteArrayWindow(int length) {
        if (1 > length) {
            throw new RuntimeException();
        }
        this.array = new byte[length];
    }

    public boolean isFull() {
        return this.size == this.array.length;
    }

    public int getSize() {
        return this.size;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getArray() {
        return Arrays.copyOf(this.array, this.count);
    }

    public void clear() {
        this.array = new byte[this.array.length];
        this.count = 0;
        this.size = 0;
    }

    public void nextBytes(byte[] bs, int offset, int length) {
        int start;
        int capSize = this.array.length;
        if (capSize > length) {
            capSize = length;
        }
        int end = offset + length;
        for (int i = start = end - capSize; i < end; ++i) {
            this.nextByte(bs[i]);
        }
    }

    public void nextByte(byte b) {
        if (1 > this.array.length) {
            return;
        }
        this.shuffle();
        this.array[0] = b;
        if (this.size < this.array.length) {
            ++this.size;
        }
        ++this.count;
    }

    public void shuffle() {
        if (2 > this.array.length) {
            return;
        }
        for (int i = this.array.length - 2; i >= 0; --i) {
            this.array[i + 1] = this.array[i];
        }
    }
}

