/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.gzip.GzipException;
import uk.ac.ox.well.t2d.async.gzip.GzipMetadataHandler;
import uk.ac.ox.well.t2d.async.io.ByteBufferFactory;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class GzipDecoder
extends AbstractConveyor<GunzipContext, ByteBuffer, ByteBuffer> {
    public GzipDecoder() {
        this.setPayloadManager(new ByteBufferFactory());
    }

    public ByteBufferFactory getPayloadFactory() {
        return (ByteBufferFactory)this.payloadManager;
    }

    @Override
    protected GunzipContext newContext() {
        return new GunzipContext();
    }

    protected void headerComplete(GunzipContext cxt) {
    }

    protected void footerComplete(GunzipContext cxt) {
    }

    protected class GunzipContext
    extends ProcessingContext<ByteBuffer, ByteBuffer> {
        long bytesRead = 0L;
        GzipMetadataHandler handler = new GzipMetadataHandler();
        Inflater inflater = new Inflater(true);
        CRC32 crc = new CRC32();

        @Override
        public void clear() {
            super.clear();
            this.reset();
        }

        public void reset() {
            this.inflater.reset();
            this.crc.reset();
            this.bytesRead = 0L;
            this.handler.clear();
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, ByteBuffer po, boolean endOfInput) {
            if (!this.handler.isHeaderComplete()) {
                try {
                    this.captureHeader(pi);
                    if (!pi.hasRemaining()) {
                        this.bytesRead += (long)pi.position();
                        return ProcessingResult.INPUT_COMPLETE;
                    }
                }
                catch (Exception ge) {
                    this.getContract().fail(ge);
                    return ProcessingResult.FAILURE;
                }
                if (this.handler.isHeaderComplete()) {
                    GzipDecoder.this.headerComplete(this);
                }
            }
            if (!this.inflater.finished()) {
                try {
                    this.inflate(pi, po);
                }
                catch (DataFormatException ex) {
                    this.getContract().fail(ex);
                    return ProcessingResult.FAILURE;
                }
            }
            if (this.inflater.finished() && !this.handler.isFooterComplete()) {
                this.captureFooter(pi);
                if (this.handler.isFooterComplete()) {
                    try {
                        this.handler.validateFooter(this.crc.getValue(), this.inflater.getBytesWritten());
                        GzipDecoder.this.footerComplete(this);
                    }
                    catch (GzipException ge) {
                        this.getLogger().warn("Byte Length mismatch!", ge);
                    }
                }
            }
            if (endOfInput && !pi.hasRemaining()) {
                try {
                    this.validateEndOfInput();
                }
                catch (GzipException ge) {
                    this.getContract().fail(ge);
                    return ProcessingResult.FAILURE;
                }
                po.flip();
                this.bytesRead += (long)pi.position();
                return ProcessingResult.BOTH_COMPLETE;
            }
            if (pi.hasRemaining() && this.handler.isFooterComplete()) {
                this.reset();
                po.flip();
                return ProcessingResult.OUTPUT_COMPLETE;
            }
            if (!po.hasRemaining() && pi.hasRemaining()) {
                po.flip();
                return ProcessingResult.OUTPUT_COMPLETE;
            }
            if (!pi.hasRemaining() && po.hasRemaining()) {
                this.bytesRead += (long)pi.position();
                return ProcessingResult.INPUT_COMPLETE;
            }
            if (!po.hasRemaining() && !pi.hasRemaining()) {
                po.flip();
                this.bytesRead += (long)pi.position();
                return ProcessingResult.BOTH_COMPLETE;
            }
            this.getContract().getLogger().warn("UNEXPECTED STATE: PI && PO have remaining");
            return ProcessingResult.FAILURE;
        }

        protected void inflate(ByteBuffer pi, ByteBuffer po) throws DataFormatException {
            this.setupInput(pi);
            byte[] ba = po.array();
            int pos = po.position();
            int offset = po.arrayOffset() + pos;
            int length = po.remaining();
            int ilength = this.inflater.inflate(ba, offset, length);
            this.crc.update(ba, offset, ilength);
            po.position(po.position() + ilength);
            this.teardownInput(pi);
        }

        protected void setupInput(ByteBuffer pi) {
            if (this.inflater.needsInput()) {
                byte[] ba = pi.array();
                int offset = pi.arrayOffset() + pi.position();
                int length = pi.remaining();
                this.inflater.setInput(ba, offset, length);
            }
        }

        protected void teardownInput(ByteBuffer pi) {
            if (this.inflater.finished()) {
                pi.position(pi.limit() - this.inflater.getRemaining());
            } else if (this.inflater.needsInput()) {
                pi.position(pi.limit());
            }
        }

        protected void captureHeader(ByteBuffer pi) throws Exception {
            byte b;
            while (pi.hasRemaining() && !this.handler.nextHeader(b = pi.get())) {
            }
        }

        protected void captureFooter(ByteBuffer pi) {
            if (this.handler.isFooterComplete()) {
                return;
            }
            while (pi.hasRemaining() && !this.handler.nextFooter(pi.get())) {
            }
        }

        protected void validateEndOfInput() throws GzipException {
            if (!this.handler.isHeaderComplete()) {
                throw new GzipException("Gzip header not completed before end of stream");
            }
            if (!this.inflater.finished()) {
                throw new GzipException("Gzip body not completed before end of stream");
            }
            if (!this.handler.isFooterComplete()) {
                throw new GzipException("Gzip footer not completed before end of stream");
            }
        }
    }
}

