/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip;

import java.nio.file.Path;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.parser.rig.Bypass;

public class GzipDecoderBypass
extends Bypass {
    public static final String IS_GZIPPED_KEY = "GzipDecoderBypass.IsGzipped";

    @Override
    protected boolean bypassRequired(Contract c, Bucket bin, boolean endOfInput) {
        Boolean b = (Boolean)c.get(IS_GZIPPED_KEY);
        return b == null || b == false;
    }

    @Override
    public void consume(Contract c, Bucket bin, boolean endOfInput) {
        if (this.bypassRequired(c, bin, endOfInput)) {
            this.bypassProcessor.consume(c, bin, endOfInput);
        } else {
            this.getProcessor().consume(c, bin, endOfInput);
        }
    }

    public static class Sensor
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            Path path = (Path)bin.getPayload();
            if (!c.containsKey(GzipDecoderBypass.IS_GZIPPED_KEY)) {
                if (path.getFileName().toString().endsWith(".gz")) {
                    c.put(GzipDecoderBypass.IS_GZIPPED_KEY, Boolean.TRUE);
                } else {
                    c.put(GzipDecoderBypass.IS_GZIPPED_KEY, Boolean.FALSE);
                }
            }
            this.getProcessor().consume(c, bin, endOfInput);
        }
    }
}

