/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.gzip.GzipMetadataComposer;
import uk.ac.ox.well.t2d.async.io.ByteBufferFactory;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class GzipEncoder
extends AbstractConveyor<GzipContext, ByteBuffer, ByteBuffer> {
    public static final String GZIP_BYTES_READ_KEY = "GzipEncoder.BytesRead";
    public static final String STRATEGY_KEY = "Gzip.Strategy";
    public static final String LEVEL_KEY = "Gzip.Level";

    public GzipEncoder() {
        this.setPayloadManager(new ByteBufferFactory());
    }

    public ByteBufferFactory getPayloadFactory() {
        return (ByteBufferFactory)this.payloadManager;
    }

    @Override
    protected GzipContext newContext() {
        return new GzipContext();
    }

    @Override
    public void setBucketCount(int bucketCount) {
        this.bucketCount = bucketCount * 3;
    }

    protected class GzipContext
    extends ProcessingContext<ByteBuffer, ByteBuffer> {
        GzipMetadataComposer composer = new GzipMetadataComposer();
        Deflater deflater = new Deflater(-1, true);
        CRC32 crc = new CRC32();
        ByteBuffer header;
        ByteBuffer footer;

        @Override
        public void initialize() {
            Contract c = this.getContract();
            this.composer.setup(c);
            this.header = this.composer.toHeaderByteBuffer();
            if (c.containsKey(GzipEncoder.STRATEGY_KEY)) {
                this.deflater.setStrategy((Integer)c.get(GzipEncoder.STRATEGY_KEY));
            }
            if (c.containsKey(GzipEncoder.LEVEL_KEY)) {
                this.deflater.setLevel((Integer)c.get(GzipEncoder.LEVEL_KEY));
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.reset();
        }

        public void reset() {
            this.deflater.reset();
            this.deflater.setLevel(-1);
            this.deflater.setStrategy(0);
            this.crc.reset();
            this.composer = new GzipMetadataComposer();
            this.header = null;
            this.footer = null;
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, ByteBuffer po, boolean endOfInput) {
            if (this.header.hasRemaining()) {
                this.putNoOverflow(this.header, po);
                if (this.header.hasRemaining()) {
                    po.flip();
                    return ProcessingResult.OUTPUT_COMPLETE;
                }
            }
            if (!this.deflater.finished()) {
                this.deflate(pi, po, endOfInput);
                if (this.deflater.finished()) {
                    this.composer.setCrc32(this.crc.getValue());
                    this.composer.setLength(this.deflater.getBytesRead());
                    this.footer = this.composer.toFooterByteBuffer();
                    Long byteRead = new Long(this.deflater.getBytesRead());
                    this.getContract().put(GzipEncoder.GZIP_BYTES_READ_KEY, byteRead);
                }
            }
            if (null != this.footer && this.footer.hasRemaining()) {
                this.putNoOverflow(this.footer, po);
            }
            if (endOfInput) {
                po.flip();
                if (null != this.footer && !this.footer.hasRemaining()) {
                    return ProcessingResult.BOTH_COMPLETE;
                }
                return ProcessingResult.OUTPUT_COMPLETE;
            }
            if (!po.hasRemaining() && pi.hasRemaining()) {
                po.flip();
                return ProcessingResult.OUTPUT_COMPLETE;
            }
            if (!pi.hasRemaining() && po.hasRemaining()) {
                return ProcessingResult.INPUT_COMPLETE;
            }
            if (!po.hasRemaining() && !pi.hasRemaining()) {
                po.flip();
                return ProcessingResult.BOTH_COMPLETE;
            }
            this.getContract().getLogger().warn("UNEXPECTED STATE: PI && PO have remaining");
            return ProcessingResult.FAILURE;
        }

        protected void deflate(ByteBuffer pi, ByteBuffer po, boolean endOfInput) {
            this.setupInput(pi, endOfInput);
            byte[] ba = po.array();
            int pos = po.position();
            int offset = po.arrayOffset() + pos;
            int length = po.remaining();
            int ilength = this.deflater.deflate(ba, offset, length, 0);
            po.position(po.position() + ilength);
            this.teardownInput(pi);
        }

        protected void setupInput(ByteBuffer pi, boolean endOfInput) {
            if (this.deflater.needsInput()) {
                byte[] ba = pi.array();
                int offset = pi.arrayOffset() + pi.position();
                int length = pi.remaining();
                this.deflater.setInput(ba, offset, length);
                this.crc.update(ba, offset, length);
                if (endOfInput) {
                    this.deflater.finish();
                }
            }
        }

        protected void teardownInput(ByteBuffer pi) {
            if (this.deflater.needsInput() || this.deflater.finished()) {
                pi.position(pi.limit());
            }
        }

        protected void putNoOverflow(ByteBuffer src, ByteBuffer snk) {
            if (src.hasRemaining() && snk.hasRemaining()) {
                if (snk.remaining() >= src.remaining()) {
                    snk.put(src);
                } else {
                    int remainder = snk.remaining();
                    for (int i = 0; i < remainder; ++i) {
                        snk.put(src.get());
                    }
                }
            }
        }
    }
}

