/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import uk.ac.ox.well.t2d.async.bin.BinaryUtilities;

public class GzipMetadata {
    public static final List<Byte> MAGIC_NUMBER = GzipMetadata.magicNumbers();
    public static final int DEFLATE_COMPRESSION = 8;
    protected boolean[] flags;
    protected long time;
    protected int extraFlags;
    protected int os;
    protected String name;
    protected String comment;
    protected long crc16;
    protected long length;
    protected long crc32;
    protected List<Subfield> subfields;
    protected GzipMetadata nextBlock;

    public GzipMetadata() {
        this.flags = new boolean[8];
        this.name = null;
        this.comment = null;
        this.time = 0L;
        this.extraFlags = 0;
        this.os = 0;
        this.crc16 = 0L;
        this.crc32 = 0L;
        this.length = 0L;
        this.nextBlock = null;
        this.subfields = new ArrayList<Subfield>();
    }

    public GzipMetadata(GzipMetadata gzm) {
        this.flags = gzm.flags;
        this.name = gzm.name;
        this.comment = gzm.comment;
        this.time = gzm.time;
        this.extraFlags = gzm.extraFlags;
        this.os = gzm.os;
        this.crc16 = gzm.crc16;
        this.crc32 = gzm.crc32;
        this.length = gzm.length;
        this.nextBlock = null;
        this.subfields = gzm.subfields;
    }

    public void clear() {
        this.flags = new boolean[8];
        this.name = null;
        this.comment = null;
        this.time = 0L;
        this.extraFlags = 0;
        this.os = 0;
        this.crc16 = 0L;
        this.crc32 = 0L;
        this.length = 0L;
        this.nextBlock = null;
        this.subfields.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("TEXT FLAG %b\n", this.isTextFlag());
        f.format("CRC 16 FLAG %b\n", this.isCrc16Flag());
        f.format("EXTRA FIELDS FLAG %b\n", this.isExtraFieldsFlag());
        f.format("NAME FLAG %b\n", this.isNameFlag());
        f.format("COMMENT FLAG %b\n", this.isCommentFlag());
        f.format("TIME: %tc\n", this.getTime());
        f.format("EXTRA FLAGS: %d\n", this.getExtraFlags());
        f.format("OS: %d\n", this.getOs());
        f.format("NAME: %s\n", this.getName());
        f.format("COMMENT: %s\n", this.getComment());
        f.format("SUBFIELDS: %s\n", this.getSubfields());
        f.format("CRC16: %d\n", this.getCrc16());
        f.format("LENGTH: %s\n", this.getLength());
        f.format("CRC32: %d\n", this.getCrc32());
        f.format("Next Gzip Block: %s%n", this.hasNextBlock());
        f.flush();
        return sb.toString();
    }

    public boolean hasNextBlock() {
        return null != this.nextBlock;
    }

    public GzipMetadata getNextBlock() {
        return this.nextBlock;
    }

    public boolean isTextFlag() {
        return this.flags[0];
    }

    public void setTextFlag(boolean b) {
        this.flags[0] = b;
    }

    public boolean isCrc16Flag() {
        return this.flags[1];
    }

    public boolean isExtraFieldsFlag() {
        return this.flags[2];
    }

    public boolean isNameFlag() {
        return this.flags[3];
    }

    public boolean isCommentFlag() {
        return this.flags[4];
    }

    public long getTime() {
        return this.time;
    }

    public int getExtraFlags() {
        return this.extraFlags;
    }

    public int getOs() {
        return this.os;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCrc16() {
        return this.crc16;
    }

    public long getCrc32() {
        return this.crc32;
    }

    public void setCrc32(long l) {
        this.crc32 = l;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long l) {
        this.length = l;
    }

    protected void setFlags(byte b) {
        int bm = 1;
        this.flags[0] = (b & bm) == bm;
        bm = 2;
        this.flags[1] = (b & bm) == bm;
        bm = 4;
        this.flags[2] = (b & bm) == bm;
        bm = 8;
        this.flags[3] = (b & bm) == bm;
        bm = 16;
        this.flags[4] = (b & bm) == bm;
        bm = 32;
        this.flags[5] = (b & bm) == bm;
        bm = 64;
        this.flags[6] = (b & bm) == bm;
        bm = 128;
        this.flags[7] = (b & bm) == bm;
    }

    protected byte getFlags() {
        byte b = 0;
        if (this.flags[0]) {
            b = (byte)(b | 1);
        }
        if (this.flags[1]) {
            b = (byte)(b | 2);
        }
        if (this.flags[2]) {
            b = (byte)(b | 4);
        }
        if (this.flags[3]) {
            b = (byte)(b | 8);
        }
        if (this.flags[4]) {
            b = (byte)(b | 0x10);
        }
        return b;
    }

    protected void setCrc16(byte[] b) {
        this.crc16 = BinaryUtilities.bytesToLongLe(b);
    }

    protected void setTime(byte[] b) {
        this.time = BinaryUtilities.bytesToLongLe(b);
        this.time *= 1000L;
    }

    protected void setExtraFlags(byte b) {
        this.extraFlags = b;
    }

    protected void setOs(byte b) {
        this.os = b;
    }

    public List<Subfield> getSubfields() {
        return this.subfields;
    }

    protected void setSubfields(byte[] ba) {
        Subfield sf;
        this.subfields.clear();
        for (int offset = 0; offset < ba.length; offset += sf.getLength()) {
            sf = new Subfield();
            sf.fromByteArray(ba, offset);
            this.subfields.add(sf);
        }
    }

    public boolean hasSubfields() {
        return null != this.subfields && !this.subfields.isEmpty();
    }

    protected boolean isMagicNumber(byte[] mn) {
        return MAGIC_NUMBER.get(0) == mn[0] && MAGIC_NUMBER.get(1) == mn[1];
    }

    protected static List<Byte> magicNumbers() {
        ArrayList<Byte> al = new ArrayList<Byte>();
        al.add(new Byte(31));
        al.add(new Byte(-117));
        return Collections.unmodifiableList(al);
    }

    public static class Subfield {
        private byte[] id;
        private byte[] data;

        public int getDataLength() {
            return this.getData().length;
        }

        public int getLength() {
            return this.getData().length + 4;
        }

        public byte[] getDataLengthArray() {
            return BinaryUtilities.longToBytesLe16(this.getDataLength());
        }

        public byte[] getId() {
            return this.id;
        }

        public byte getId1() {
            return this.id[0];
        }

        public byte getId2() {
            return this.id[1];
        }

        public void setId(byte[] id) {
            this.id = id;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            if (data.length > 65535) {
                throw new RuntimeException("Gzip unable to handle Subfied data sections greater than length 65535");
            }
            this.data = data;
        }

        public byte[] toByteArray() {
            byte[] ba = new byte[this.getDataLength() + 4];
            ba[0] = this.id[0];
            ba[1] = this.id[1];
            byte[] len = this.getDataLengthArray();
            System.arraycopy(len, 0, ba, 2, len.length);
            System.arraycopy(this.data, 0, ba, 4, this.data.length);
            return ba;
        }

        public void fromByteArray(byte[] ba, int offset) {
            this.id = new byte[2];
            this.id[0] = ba[offset + 0];
            this.id[1] = ba[offset + 1];
            byte[] len = new byte[]{ba[offset + 2], ba[offset + 3]};
            int dlen = (int)BinaryUtilities.bytesToLongLe(len);
            this.data = new byte[dlen];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = ba[offset + 4 + i];
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Formatter f = new Formatter(sb);
            f.format("ID: %d %d, Length: %d, Data:", this.id[0], this.id[1], this.getDataLength());
            for (byte b : this.data) {
                f.format(" %x", b);
            }
            f.format(", DataAsInteger: %d", BinaryUtilities.bytesToLongLe(this.data));
            return sb.toString();
        }
    }
}

